/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.jex.ssl.core;

import io.avaje.jex.spi.ClassResourceLoader;
import io.avaje.jex.ssl.SslConfig;
import io.avaje.jex.ssl.SslConfigException;
import io.avaje.jex.ssl.TrustConfig;
import io.avaje.jex.ssl.core.DTrustConfig;
import io.avaje.jex.ssl.core.KeyStoreUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.Provider;
import java.util.function.Consumer;

final class DSslConfig
implements SslConfig {
    private static final String MULTIPLE_IDENTITY = "Both the certificate and key must be provided using the same method";
    private String identityPassword;
    private KeyStore keyStore = null;
    private boolean loadedIdentity;
    private Provider securityProvider = null;
    private DTrustConfig trustConfig = null;
    private ClassResourceLoader resourceLoader = ClassResourceLoader.fromClass(SslConfig.class);

    DSslConfig() {
    }

    String identityPassword() {
        return this.identityPassword;
    }

    KeyStore keyStore() {
        return this.keyStore;
    }

    @Override
    public void keystoreFromClasspath(String keyStoreFile, String keyStorePassword, String identityPassword) {
        this.keystoreFromInputStream(this.loadCP(keyStoreFile), keyStorePassword, identityPassword);
    }

    @Override
    public void keystoreFromInputStream(InputStream keyStoreInputStream, String keyStorePassword, String identityPassword) {
        this.setKeyStore(KeyStoreUtil.loadKeyStore(keyStoreInputStream, keyStorePassword.toCharArray()));
        this.identityPassword = identityPassword != null ? identityPassword : keyStorePassword;
    }

    @Override
    public void keystoreFromPath(String keyStorePath, String keyStorePassword, String identityPassword) {
        try {
            Path path = Paths.get(keyStorePath, new String[0]);
            this.setKeyStore(KeyStoreUtil.loadKeyStore(Files.newInputStream(path, new OpenOption[0]), keyStorePassword.toCharArray()));
            this.identityPassword = identityPassword != null ? identityPassword : keyStorePassword;
        }
        catch (IOException e) {
            throw new SslConfigException("Failed to load keystore from path: " + keyStorePath, e);
        }
    }

    private InputStream loadCP(String path) {
        InputStream url = null;
        try {
            url = this.resourceLoader.loadResource(path).openStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return url;
    }

    boolean loadedIdentity() {
        return this.loadedIdentity;
    }

    @Override
    public void pemFromClasspath(String certificateFile, String privateKeyFile, String password) {
        this.pemFromInputStream(this.loadCP(certificateFile), this.loadCP(privateKeyFile), password);
    }

    @Override
    public void pemFromInputStream(InputStream certificateInputStream, InputStream privateKeyInputStream, String password) {
        try {
            String keyContent = new String(privateKeyInputStream.readAllBytes());
            this.setKeyStore(KeyStoreUtil.loadIdentityFromPem(certificateInputStream, keyContent, password != null ? password.toCharArray() : null));
            this.identityPassword = this.identityPassword != null ? this.identityPassword : "";
        }
        catch (IOException e) {
            throw new SslConfigException("Failed to read PEM content from streams", e);
        }
    }

    @Override
    public void pemFromPath(String certificatePath, String privateKeyPath, String password) {
        try (InputStream certContent = Files.newInputStream(Paths.get(certificatePath, new String[0]), new OpenOption[0]);){
            Path keyPath = Paths.get(privateKeyPath, new String[0]);
            String keyContent = Files.readString(keyPath);
            this.setKeyStore(KeyStoreUtil.loadIdentityFromPem(certContent, keyContent, password != null ? password.toCharArray() : null));
            this.identityPassword = this.identityPassword != null ? this.identityPassword : "";
        }
        catch (IOException e) {
            throw new SslConfigException("Failed to read PEM files", e);
        }
    }

    @Override
    public void pemFromString(String certificateString, String privateKeyString, String password) {
        this.setKeyStore(KeyStoreUtil.loadIdentityFromPem(new ByteArrayInputStream(certificateString.getBytes(StandardCharsets.UTF_8)), privateKeyString, password != null ? password.toCharArray() : null));
        this.identityPassword = this.identityPassword != null ? this.identityPassword : "";
    }

    @Override
    public SslConfig resourceLoader(Class<?> clazz) {
        this.resourceLoader = ClassResourceLoader.fromClass(clazz);
        return this;
    }

    Provider securityProvider() {
        return this.securityProvider;
    }

    @Override
    public void securityProvider(Provider securityProvider) {
        this.securityProvider = securityProvider;
    }

    private void setKeyStore(KeyStore keyStore) {
        if (this.loadedIdentity) {
            throw new SslConfigException(MULTIPLE_IDENTITY);
        }
        if (keyStore != null) {
            this.loadedIdentity = true;
            this.keyStore = keyStore;
        }
    }

    DTrustConfig trustConfig() {
        return this.trustConfig;
    }

    @Override
    public void withTrustConfig(Consumer<TrustConfig> trustConfigConsumer) {
        this.trustConfig = this.trustConfig == null ? new DTrustConfig(this::loadCP) : this.trustConfig;
        trustConfigConsumer.accept(this.trustConfig);
    }
}

