/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.config.jackson.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.atomix.utils.ConfigurationException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;

public abstract class PolymorphicTypeDeserializer<T>
extends StdDeserializer<T> {
    private static final String TYPE_KEY = "type";
    private final Function<String, Class<? extends T>> concreteFactory;

    protected PolymorphicTypeDeserializer(Class<?> type, Function<String, Class<? extends T>> concreteFactory) {
        super(type);
        this.concreteFactory = concreteFactory;
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        ObjectNode root = (ObjectNode)mapper.readTree(p);
        Iterator iterator = root.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!((String)entry.getKey()).equals(TYPE_KEY)) continue;
            Class<? extends T> configClass = this.concreteFactory.apply(((JsonNode)entry.getValue()).asText());
            root.remove(TYPE_KEY);
            return (T)mapper.convertValue((Object)root, configClass);
        }
        throw new ConfigurationException("Failed to deserialize polymorphic " + this._valueClass.getSimpleName() + " configuration");
    }
}

