/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.config.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import io.atomix.core.config.ConfigProvider;
import io.atomix.core.config.jackson.impl.ConfigPropertyNamingStrategy;
import io.atomix.core.config.jackson.impl.PartitionGroupDeserializer;
import io.atomix.core.config.jackson.impl.PrimitiveConfigDeserializer;
import io.atomix.core.config.jackson.impl.PrimitiveProtocolDeserializer;
import io.atomix.primitive.PrimitiveConfig;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.primitive.protocol.PrimitiveProtocolConfig;
import io.atomix.utils.Config;
import io.atomix.utils.ConfigurationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JacksonConfigProvider
implements ConfigProvider {
    private static final String YAML_EXT = ".yaml";
    private static final String YML_EXT = ".yml";
    private static final String JSON_EXT = ".json";

    public boolean isConfigFile(File file) {
        return this.isYaml(file) || this.isJson(file);
    }

    private boolean isYaml(File file) {
        return file.getName().endsWith(YAML_EXT) || file.getName().endsWith(YML_EXT);
    }

    private boolean isJson(File file) {
        return file.getName().endsWith(JSON_EXT);
    }

    private boolean isJson(String config) {
        return config.trim().startsWith("{") && config.trim().endsWith("}");
    }

    public <C extends Config> C load(String config, Class<C> type) {
        if (this.isJson(config)) {
            return this.loadJson(config, type);
        }
        return this.loadYaml(config, type);
    }

    public <C extends Config> C load(File file, Class<C> type) {
        if (this.isYaml(file)) {
            return this.loadYaml(file, type);
        }
        if (this.isJson(file)) {
            return this.loadJson(file, type);
        }
        throw new ConfigurationException("Unknown file type: " + file.getName());
    }

    private <C extends Config> C loadYaml(File file, Class<C> type) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new InterpolatingYamlFactory());
        this.setupObjectMapper(mapper);
        try {
            return (C)((Config)mapper.readValue(file, type));
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to parse YAML file", (Throwable)e);
        }
    }

    private <C extends Config> C loadJson(File file, Class<C> type) {
        ObjectMapper mapper = new ObjectMapper();
        this.setupObjectMapper(mapper);
        try {
            return (C)((Config)mapper.readValue(file, type));
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to parse JSON file", (Throwable)e);
        }
    }

    private <C extends Config> C loadYaml(String config, Class<C> type) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new InterpolatingYamlFactory());
        this.setupObjectMapper(mapper);
        try {
            return (C)((Config)mapper.readValue(config, type));
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to parse YAML file", (Throwable)e);
        }
    }

    private <C extends Config> C loadJson(String config, Class<C> type) {
        ObjectMapper mapper = new ObjectMapper();
        this.setupObjectMapper(mapper);
        try {
            return (C)((Config)mapper.readValue(config, type));
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to parse JSON file", (Throwable)e);
        }
    }

    private void setupObjectMapper(ObjectMapper mapper) {
        mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new ConfigPropertyNamingStrategy());
        mapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        mapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES});
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        mapper.configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, true);
        SimpleModule module = new SimpleModule("PolymorphicTypes");
        module.addDeserializer(PartitionGroupConfig.class, (JsonDeserializer)new PartitionGroupDeserializer());
        module.addDeserializer(PrimitiveProtocolConfig.class, (JsonDeserializer)new PrimitiveProtocolDeserializer());
        module.addDeserializer(PrimitiveConfig.class, (JsonDeserializer)new PrimitiveConfigDeserializer());
        mapper.registerModule((Module)module);
    }

    private static class InterpolatingYamlParser
    extends YAMLParser {
        private final Pattern sysPattern = Pattern.compile("\\$\\{sys:([A-Za-z0-9-_.]+)\\}");
        private final Pattern envPattern = Pattern.compile("\\$\\{env:([A-Za-z0-9_]+)\\}");

        InterpolatingYamlParser(IOContext ctxt, BufferRecycler br, int parserFeatures, int formatFeatures, ObjectCodec codec, Reader reader) {
            super(ctxt, br, parserFeatures, formatFeatures, codec, reader);
        }

        public String getText() throws IOException {
            String value = super.getText();
            return value != null ? this.interpolateString(value) : null;
        }

        public String getValueAsString() throws IOException {
            return this.getValueAsString(null);
        }

        public String getValueAsString(String defaultValue) throws IOException {
            String value = super.getValueAsString(defaultValue);
            return value != null ? this.interpolateString(value) : null;
        }

        private String interpolateString(String value) {
            value = this.interpolate(value, this.sysPattern, name -> System.getProperty(name));
            value = this.interpolate(value, this.envPattern, name -> System.getenv(name));
            return value;
        }

        private String interpolate(String value, Pattern pattern, Function<String, String> supplier) {
            if (value == null) {
                return null;
            }
            Matcher matcher = pattern.matcher(value);
            while (matcher.find()) {
                String name = matcher.group(1);
                String replace = supplier.apply(name);
                String group = matcher.group(0);
                if (group.equals(value)) {
                    return replace;
                }
                if (replace == null) {
                    replace = "";
                }
                Pattern subPattern = Pattern.compile(Pattern.quote(group));
                value = subPattern.matcher(value).replaceAll(replace);
            }
            return value;
        }
    }

    private static class InterpolatingYamlFactory
    extends YAMLFactory {
        private InterpolatingYamlFactory() {
        }

        protected YAMLParser _createParser(InputStream in, IOContext ctxt) throws IOException {
            return new InterpolatingYamlParser(ctxt, this._getBufferRecycler(), this._parserFeatures, this._yamlParserFeatures, this._objectCodec, this._createReader(in, null, ctxt));
        }

        protected YAMLParser _createParser(Reader r, IOContext ctxt) throws IOException {
            return new InterpolatingYamlParser(ctxt, this._getBufferRecycler(), this._parserFeatures, this._yamlParserFeatures, this._objectCodec, r);
        }
    }
}

