/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.dev.services.ollama;

import io.arconia.dev.services.ollama.OllamaDevServicesProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.devtools.restart.RestartScope;
import org.springframework.boot.testcontainers.service.connection.ServiceConnection;
import org.springframework.boot.testcontainers.service.connection.ServiceConnectionAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.testcontainers.ollama.OllamaContainer;
import org.testcontainers.utility.DockerImageName;

@AutoConfiguration(before={ServiceConnectionAutoConfiguration.class})
@ConditionalOnProperty(prefix="arconia.dev.services.ollama", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={OllamaDevServicesProperties.class})
@Import(value={ConfigurationWithRestart.class, ConfigurationWithoutRestart.class})
public class OllamaDevServicesAutoConfiguration {
    public static final String COMPATIBLE_IMAGE_NAME = "ollama/ollama";

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"org.springframework.boot.devtools.restart.RestartScope"})
    public static class ConfigurationWithoutRestart {
        @Bean
        @ServiceConnection
        @ConditionalOnMissingBean
        OllamaContainer ollamaContainerNoRestartScope(OllamaDevServicesProperties properties) {
            return (OllamaContainer)new OllamaContainer(DockerImageName.parse((String)properties.getImageName()).asCompatibleSubstituteFor(OllamaDevServicesAutoConfiguration.COMPATIBLE_IMAGE_NAME)).withReuse(properties.isReusable());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RestartScope.class})
    public static class ConfigurationWithRestart {
        @Bean
        @RestartScope
        @ServiceConnection
        @ConditionalOnMissingBean
        OllamaContainer ollamaContainer(OllamaDevServicesProperties properties) {
            return (OllamaContainer)new OllamaContainer(DockerImageName.parse((String)properties.getImageName()).asCompatibleSubstituteFor(OllamaDevServicesAutoConfiguration.COMPATIBLE_IMAGE_NAME)).withReuse(properties.isReusable());
        }
    }
}

