/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.plugins.demo.custompathparser;

import io.apiman.common.util.ApimanPathUtils;
import io.apiman.gateway.engine.IApiRequestPathParser;
import io.apiman.gateway.engine.beans.util.HeaderMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CustomPathParserImpl
implements IApiRequestPathParser {
    private final String defaultOrgName;

    public CustomPathParserImpl(Map<String, String> config) {
        this.defaultOrgName = config.getOrDefault("defaultOrgName", "DefaultOrg");
    }

    public ApimanPathUtils.ApiRequestPathInfo parseEndpoint(String path, HeaderMap headers) {
        String[] split = StringUtils.split((String)path, (String)"/", (int)3);
        if (split == null || split.length < 2) {
            throw new IllegalArgumentException("Invalid path format, expected /apiId/apiVersion/<resource path>");
        }
        ApimanPathUtils.ApiRequestPathInfo parsed = new ApimanPathUtils.ApiRequestPathInfo();
        parsed.orgId = this.defaultOrgName;
        parsed.apiId = split[0];
        parsed.apiVersion = split[1];
        parsed.resource = split.length > 2 ? "/" + split[2] : "/";
        return parsed;
    }
}

