/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.plugins.uniqueheader;

import io.apiman.gateway.engine.beans.ApiRequest;
import io.apiman.gateway.engine.beans.ApiResponse;
import io.apiman.gateway.engine.beans.exceptions.ConfigurationParseException;
import io.apiman.gateway.engine.beans.util.HeaderMap;
import io.apiman.gateway.engine.policies.AbstractMappedPolicy;
import io.apiman.gateway.engine.policy.IPolicyChain;
import io.apiman.gateway.engine.policy.IPolicyContext;
import io.apiman.plugins.uniqueheader.beans.UniqueHeaderBean;
import io.apiman.plugins.uniqueheader.util.Messages;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

public class UniqueHeaderPolicy
extends AbstractMappedPolicy<UniqueHeaderBean> {
    private static final Messages MESSAGES = new Messages("io.apiman.plugins.uniqueheader", "UniqueHeaderPolicy");
    private static final String UNIQUE_HEADER_KEY = "unique.header.value";

    protected Class<UniqueHeaderBean> getConfigurationClass() {
        return UniqueHeaderBean.class;
    }

    public UniqueHeaderBean parseConfiguration(String jsonConfiguration) throws ConfigurationParseException {
        UniqueHeaderBean config = (UniqueHeaderBean)super.parseConfiguration(jsonConfiguration);
        if (StringUtils.isBlank((String)config.getHeaderName())) {
            throw new ConfigurationParseException(MESSAGES.format("Error.BlankHeaderName", new Object[0]));
        }
        return config;
    }

    protected void doApply(ApiRequest request, IPolicyContext context, UniqueHeaderBean config, IPolicyChain<ApiRequest> chain) {
        this.handleHeader(request.getHeaders(), context, config);
        chain.doApply((Object)request);
    }

    protected void doApply(ApiResponse response, IPolicyContext context, UniqueHeaderBean config, IPolicyChain<ApiResponse> chain) {
        String uniqueValue;
        if (Boolean.TRUE.equals(config.getResponseHeader()) && Objects.nonNull(uniqueValue = (String)context.getAttribute(UNIQUE_HEADER_KEY, null))) {
            response.getHeaders().put(config.getHeaderName(), uniqueValue);
        }
        super.doApply(response, context, (Object)config, chain);
    }

    private void handleHeader(HeaderMap headers, IPolicyContext context, UniqueHeaderBean config) {
        String headerValue = null;
        if (!config.isOverwriteHeaderValue()) {
            headerValue = headers.get(config.getHeaderName());
        }
        if (StringUtils.isBlank(headerValue)) {
            headerValue = this.generateUniqueString();
        }
        headers.put(config.getHeaderName(), headerValue);
        context.setAttribute(UNIQUE_HEADER_KEY, (Object)headerValue);
    }

    private String generateUniqueString() {
        return UUID.randomUUID().toString();
    }
}

