/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.plugins.uniqueheader;

import io.apiman.gateway.engine.beans.ApiRequest;
import io.apiman.gateway.engine.beans.exceptions.ConfigurationParseException;
import io.apiman.gateway.engine.policies.AbstractMappedPolicy;
import io.apiman.gateway.engine.policy.IPolicyChain;
import io.apiman.gateway.engine.policy.IPolicyContext;
import io.apiman.plugins.uniqueheader.beans.UniqueHeaderBean;
import io.apiman.plugins.uniqueheader.util.Messages;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

public class UniqueHeaderPolicy
extends AbstractMappedPolicy<UniqueHeaderBean> {
    private static final Messages MESSAGES = new Messages("io.apiman.plugins.uniqueheader", "UniqueHeaderPolicy");

    protected Class<UniqueHeaderBean> getConfigurationClass() {
        return UniqueHeaderBean.class;
    }

    public UniqueHeaderBean parseConfiguration(String jsonConfiguration) throws ConfigurationParseException {
        UniqueHeaderBean config = (UniqueHeaderBean)super.parseConfiguration(jsonConfiguration);
        if (StringUtils.isBlank((String)config.getHeaderName())) {
            throw new ConfigurationParseException(MESSAGES.format("Error.BlankHeaderName", new Object[0]));
        }
        return config;
    }

    protected void doApply(ApiRequest request, IPolicyContext context, UniqueHeaderBean config, IPolicyChain<ApiRequest> chain) {
        request.getHeaders().put(config.getHeaderName(), this.generateUniqueString());
        chain.doApply((Object)request);
    }

    protected String generateUniqueString() {
        return UUID.randomUUID().toString();
    }
}

