/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.rhino.compiler;

import io.apigee.trireme.rhino.compiler.MacroProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.optimizer.ClassCompiler;

@Mojo(name="compile")
public class RhinoCompiler
extends AbstractMojo {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    @Parameter(defaultValue="${basedir}/src/main/javascript")
    private String directory = "${basedir}/src/main/javascript";
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private String targetPath = "${project.build.outputDirectory}";
    @Parameter(defaultValue="**/*.js")
    private String pattern = "**/*.js";
    @Parameter
    private String codePrefix;
    @Parameter
    private String codePostfix;
    @Parameter
    private boolean generateSource = true;
    @Parameter
    private int optimizationLevel = 1;
    @Parameter
    private boolean debugInfo;
    @Parameter
    private boolean generateObserverCount;
    @Parameter
    private String macroFile;

    private CompilerEnvirons createEnvironment() {
        CompilerEnvirons env = new CompilerEnvirons();
        env.setLanguageVersion(180);
        env.setGenerateDebugInfo(this.debugInfo);
        env.setOptimizationLevel(this.optimizationLevel);
        env.setGeneratingSource(this.generateSource);
        env.setRecordingComments(false);
        env.setRecoverFromErrors(false);
        env.setGenerateObserverCount(this.generateObserverCount);
        return env;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        MacroProcessor macro = null;
        if (this.macroFile != null) {
            try {
                macro = new MacroProcessor(this.macroFile);
            }
            catch (IOException e) {
                throw new MojoFailureException(e.toString());
            }
        }
        Log log = this.getLog();
        File baseDir = new File(this.directory);
        if (baseDir.exists() && baseDir.isDirectory()) {
            CompilerEnvirons env = this.createEnvironment();
            ClassCompiler compiler = new ClassCompiler(env);
            File targetDirFile = new File(this.targetPath);
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(baseDir);
            scanner.setIncludes(new String[]{this.pattern});
            scanner.scan();
            for (String fn : scanner.getIncludedFiles()) {
                File input = new File(baseDir, fn);
                String baseName = this.getBaseName(fn);
                String className = baseName.replaceAll("[/\\\\]", ".");
                File output = new File(targetDirFile, baseName + ".class");
                File srcOutput = new File(targetDirFile, baseName + ".js");
                if (input.lastModified() < output.lastModified()) continue;
                if (output.getParentFile() != null) {
                    output.getParentFile().mkdirs();
                }
                log.info((CharSequence)("Compiling " + fn + " to " + output.getPath()));
                try {
                    Object[] bytes;
                    String source = this.loadSource(input, macro);
                    try {
                        bytes = compiler.compileToClassFiles(this.addPrefixes(source), input.getName(), 1, className);
                    }
                    catch (RhinoException re) {
                        throw new MojoExecutionException("Error compiling script file " + fn + " :" + re.lineNumber() + ':' + (Object)((Object)re), (Exception)((Object)re));
                    }
                    if (bytes.length > 2) {
                        throw new MojoExecutionException("Compiler produced more than one class, which was not expected");
                    }
                    this.writeFromArray((byte[])bytes[1], output);
                    this.writeFromString(source, srcOutput);
                }
                catch (IOException ioe) {
                    throw new MojoExecutionException("Error reading or writing file: " + ioe, (Exception)ioe);
                }
            }
        } else {
            log.info((CharSequence)("Ignoring non-existent directory " + baseDir.getPath()));
        }
    }

    private String getBaseName(String fn) {
        int lastDot = fn.lastIndexOf(46);
        if (lastDot > 0) {
            return fn.substring(0, lastDot);
        }
        return fn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadSource(File in, MacroProcessor macro) throws IOException {
        StringBuilder str = new StringBuilder();
        try (BufferedReader rdr = new BufferedReader(new FileReader(in));){
            String line;
            do {
                if ((line = rdr.readLine()) == null) continue;
                if (macro != null) {
                    line = macro.processLine(line);
                }
                str.append(line).append('\n');
            } while (line != null);
            String string = str.toString();
            return string;
        }
    }

    private String addPrefixes(String s) {
        StringBuilder p = new StringBuilder(s.length());
        if (this.codePrefix != null) {
            p.append(this.codePrefix);
        }
        p.append(s);
        if (this.codePostfix != null) {
            p.append(this.codePostfix);
        }
        return p.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFromArray(byte[] bytes, File out) throws IOException {
        if (out.exists()) {
            out.delete();
        }
        try (FileOutputStream of = new FileOutputStream(out);){
            of.write(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFromString(String str, File out) throws IOException {
        if (out.exists()) {
            out.delete();
        }
        FileOutputStream of = new FileOutputStream(out);
        try (OutputStreamWriter ofr = new OutputStreamWriter(of);){
            ofr.write(str);
        }
    }
}

