/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.rhino.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.optimizer.ClassCompiler;

@Mojo(name="compile")
public class RhinoCompiler
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}/src/main/javascript")
    private String directory = "${basedir}/src/main/javascript";
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private String targetPath = "${project.build.outputDirectory}";
    @Parameter
    private String codePrefix;
    @Parameter
    private String codePostfix;
    @Parameter
    private boolean generateSource;
    @Parameter
    private int optimizationLevel = 1;
    @Parameter
    private boolean debugInfo;

    private CompilerEnvirons createEnvironment() {
        CompilerEnvirons env = new CompilerEnvirons();
        env.setLanguageVersion(180);
        env.setGenerateDebugInfo(this.debugInfo);
        env.setOptimizationLevel(this.optimizationLevel);
        env.setGeneratingSource(this.generateSource);
        env.setRecordingComments(false);
        env.setRecoverFromErrors(false);
        env.setGenerateObserverCount(true);
        return env;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        File baseDir = new File(this.directory);
        if (baseDir.exists() && baseDir.isDirectory()) {
            CompilerEnvirons env = this.createEnvironment();
            ClassCompiler compiler = new ClassCompiler(env);
            File targetDirFile = new File(this.targetPath);
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(baseDir);
            scanner.setIncludes(new String[]{"**/*.js"});
            scanner.scan();
            for (String fn : scanner.getIncludedFiles()) {
                File input = new File(baseDir, fn);
                String baseName = this.getBaseName(fn);
                String className = baseName.replace("/", ".");
                File output = new File(targetDirFile, baseName + ".class");
                if (input.lastModified() < output.lastModified()) continue;
                if (output.getParentFile() != null) {
                    output.getParentFile().mkdirs();
                }
                log.info((CharSequence)("Compiling " + fn + " to " + output.getPath()));
                try {
                    Object[] bytes;
                    try {
                        bytes = compiler.compileToClassFiles(this.loadSource(input), input.getPath(), 1, className);
                    }
                    catch (RhinoException re) {
                        throw new MojoExecutionException("Error compiling script file " + fn + " :" + re.lineNumber() + ':' + (Object)((Object)re), (Exception)((Object)re));
                    }
                    if (bytes.length > 2) {
                        throw new MojoExecutionException("Compiler produced more than one class, which was not expected");
                    }
                    this.writeFromArray((byte[])bytes[1], output);
                }
                catch (IOException ioe) {
                    throw new MojoExecutionException("Error reading or writing file: " + ioe, (Exception)ioe);
                }
            }
        } else {
            log.info((CharSequence)("Ignoring non-existent directory " + baseDir.getPath()));
        }
    }

    private String getBaseName(String fn) {
        int lastDot = fn.lastIndexOf(46);
        if (lastDot > 0) {
            return fn.substring(0, lastDot);
        }
        return fn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadSource(File in) throws IOException {
        StringBuilder str = new StringBuilder();
        InputStreamReader rdr = new InputStreamReader(new FileInputStream(in));
        char[] buf = new char[4096];
        if (this.codePrefix != null) {
            str.append(this.codePrefix);
        }
        try {
            int cr;
            do {
                if ((cr = rdr.read(buf)) <= 0) continue;
                str.append(buf, 0, cr);
            } while (cr > 0);
        }
        finally {
            rdr.close();
        }
        if (this.codePostfix != null) {
            str.append(this.codePostfix);
        }
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFromArray(byte[] bytes, File out) throws IOException {
        if (out.exists()) {
            out.delete();
        }
        FileOutputStream of = new FileOutputStream(out);
        try {
            of.write(bytes);
        }
        finally {
            of.close();
        }
    }
}

