/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.client;

import com.microsoft.kiota.RequestAdapter;
import io.apicurio.registry.client.RegistryClientOptions;
import io.apicurio.registry.client.auth.VertXAuthFactory;
import io.kiota.http.vertx.VertXRequestAdapter;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClosedException;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class RegistryClientRequestAdapterFactory {
    protected static RequestAdapter createRequestAdapter(RegistryClientOptions options, Vertx defaultVertx) {
        if (options == null) {
            throw new IllegalArgumentException("RegistryClientOptions cannot be null");
        }
        RegistryClientRequestAdapterFactory.validateRegistryUrl(options);
        RegistryClientRequestAdapterFactory.validateAuth(options);
        Vertx vertxToUse = options.getVertx() != null ? options.getVertx() : defaultVertx;
        WebClientOptions webClientOptions = RegistryClientRequestAdapterFactory.buildWebClientOptions(options);
        RequestAdapter adapter = switch (options.getAuthType()) {
            case RegistryClientOptions.AuthType.ANONYMOUS -> RegistryClientRequestAdapterFactory.createAnonymous(vertxToUse, webClientOptions);
            case RegistryClientOptions.AuthType.BASIC -> RegistryClientRequestAdapterFactory.createBasicAuth(options.getUsername(), options.getPassword(), vertxToUse, webClientOptions);
            case RegistryClientOptions.AuthType.OAUTH2 -> RegistryClientRequestAdapterFactory.createOAuth2(options.getTokenEndpoint(), options.getClientId(), options.getClientSecret(), options.getScope(), vertxToUse, webClientOptions);
            case RegistryClientOptions.AuthType.CUSTOM_WEBCLIENT -> RegistryClientRequestAdapterFactory.createCustomWebClient(options.getWebClient());
            default -> throw new IllegalArgumentException("Unsupported authentication type: " + String.valueOf((Object)options.getAuthType()));
        };
        adapter.setBaseUrl(options.getRegistryUrl());
        if (options.isRetryEnabled()) {
            adapter = RegistryClientRequestAdapterFactory.createRetryProxy(adapter, options);
        }
        return adapter;
    }

    private static RequestAdapter createAnonymous(Vertx vertx, WebClientOptions webClientOptions) {
        WebClient webClient = webClientOptions == null ? WebClient.create((Vertx)vertx) : WebClient.create((Vertx)vertx, (WebClientOptions)webClientOptions);
        return new VertXRequestAdapter(webClient);
    }

    private static RequestAdapter createBasicAuth(String username, String password, Vertx vertx, WebClientOptions webClientOptions) {
        WebClient webClient = VertXAuthFactory.buildSimpleAuthWebClient(vertx, webClientOptions, username, password);
        return new VertXRequestAdapter(webClient);
    }

    private static RequestAdapter createOAuth2(String tokenEndpoint, String clientId, String clientSecret, String scope, Vertx vertx, WebClientOptions webClientOptions) {
        WebClient webClient = VertXAuthFactory.buildOIDCWebClient(vertx, webClientOptions, tokenEndpoint, clientId, clientSecret, scope);
        return new VertXRequestAdapter(webClient);
    }

    private static RequestAdapter createCustomWebClient(WebClient webClient) {
        if (webClient == null) {
            throw new IllegalArgumentException("WebClient cannot be null");
        }
        return new VertXRequestAdapter(webClient);
    }

    private static RequestAdapter createRetryProxy(RequestAdapter delegate, RegistryClientOptions options) {
        return (RequestAdapter)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new Class[]{RequestAdapter.class}, (InvocationHandler)new RetryInvocationHandler(delegate, options.getMaxRetryAttempts(), options.getRetryDelayMs(), options.getBackoffMultiplier(), options.getMaxRetryDelayMs()));
    }

    private static WebClientOptions buildWebClientOptions(RegistryClientOptions options) {
        boolean hasSslConfig;
        boolean bl = hasSslConfig = options.getTrustStoreType() != RegistryClientOptions.TrustStoreType.NONE || options.isTrustAll() || !options.isVerifyHost();
        if (!hasSslConfig) {
            return null;
        }
        WebClientOptions webClientOptions = new WebClientOptions();
        webClientOptions.setSsl(true);
        if (options.isTrustAll()) {
            webClientOptions.setTrustAll(true);
        }
        webClientOptions.setVerifyHost(options.isVerifyHost());
        switch (options.getTrustStoreType()) {
            case JKS: {
                JksOptions jksOptions = new JksOptions().setPath(options.getTrustStorePath()).setPassword(options.getTrustStorePassword());
                webClientOptions.setTrustOptions((TrustOptions)jksOptions);
                break;
            }
            case PEM: {
                PemTrustOptions pemOptions = new PemTrustOptions();
                for (String certPath : options.getPemCertPaths()) {
                    pemOptions.addCertPath(certPath);
                }
                webClientOptions.setTrustOptions((TrustOptions)pemOptions);
                break;
            }
        }
        return webClientOptions;
    }

    private static void validateRegistryUrl(RegistryClientOptions options) {
        String registryUrl = options.getRegistryUrl();
        if (registryUrl == null || registryUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("Registry URL cannot be null or empty");
        }
    }

    private static void validateAuth(RegistryClientOptions options) {
        switch (options.getAuthType()) {
            case ANONYMOUS: 
            case CUSTOM_WEBCLIENT: {
                break;
            }
            case BASIC: {
                RegistryClientRequestAdapterFactory.validateCredentials(options.getUsername(), options.getPassword());
                break;
            }
            case OAUTH2: {
                RegistryClientRequestAdapterFactory.validateOAuth2Credentials(options.getTokenEndpoint(), options.getClientId(), options.getClientSecret());
            }
        }
    }

    private static void validateCredentials(String username, String password) {
        if (username == null || username.trim().isEmpty()) {
            throw new IllegalArgumentException("Username cannot be null or empty");
        }
        if (password == null || password.trim().isEmpty()) {
            throw new IllegalArgumentException("Password cannot be null or empty");
        }
    }

    private static void validateOAuth2Credentials(String tokenEndpoint, String clientId, String clientSecret) {
        if (tokenEndpoint == null || tokenEndpoint.trim().isEmpty()) {
            throw new IllegalArgumentException("Token endpoint cannot be null or empty");
        }
        if (clientId == null || clientId.trim().isEmpty()) {
            throw new IllegalArgumentException("Client ID cannot be null or empty");
        }
        if (clientSecret == null || clientSecret.trim().isEmpty()) {
            throw new IllegalArgumentException("Client secret cannot be null or empty");
        }
    }

    private static class RetryInvocationHandler
    implements InvocationHandler {
        private final RequestAdapter delegate;
        private final int maxRetryAttempts;
        private final long initialRetryDelayMs;
        private final double backoffMultiplier;
        private final long maxRetryDelayMs;

        public RetryInvocationHandler(RequestAdapter delegate, int maxRetryAttempts, long initialRetryDelayMs, double backoffMultiplier, long maxRetryDelayMs) {
            this.delegate = delegate;
            this.maxRetryAttempts = maxRetryAttempts;
            this.initialRetryDelayMs = initialRetryDelayMs;
            this.backoffMultiplier = backoffMultiplier;
            this.maxRetryDelayMs = maxRetryDelayMs;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            int attempt = 0;
            while (true) {
                Throwable originalCause = null;
                try {
                    return method.invoke((Object)this.delegate, args);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (originalCause == null) {
                        originalCause = cause;
                    }
                    if (RetryInvocationHandler.isRetryable(cause) && attempt < this.maxRetryAttempts) {
                        long delayMs = this.calculateRetryDelay(++attempt);
                        try {
                            Thread.sleep(delayMs);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException("Retry interrupted", interruptedException);
                        }
                        continue;
                    }
                    throw originalCause;
                }
                break;
            }
        }

        private static boolean isRetryable(Throwable cause) {
            return cause instanceof HttpClosedException;
        }

        private long calculateRetryDelay(int attempt) {
            double delay = (double)this.initialRetryDelayMs * Math.pow(this.backoffMultiplier, attempt - 1);
            return Math.min((long)delay, this.maxRetryDelayMs);
        }
    }
}

