/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.client;

import io.vertx.core.Vertx;
import io.vertx.ext.web.client.WebClient;

public class RegistryClientOptions {
    private String registryUrl;
    private Vertx vertx;
    private AuthType authType = AuthType.ANONYMOUS;
    private String username;
    private String password;
    private String tokenEndpoint;
    private String clientId;
    private String clientSecret;
    private String scope;
    private WebClient webClient;
    private boolean retryEnabled = false;
    private int maxRetryAttempts = 3;
    private long retryDelayMs = 1000L;
    private double backoffMultiplier = 2.0;
    private long maxRetryDelayMs = 10000L;
    private TrustStoreType trustStoreType = TrustStoreType.NONE;
    private String trustStorePath;
    private String trustStorePassword;
    private String[] pemCertPaths;
    private boolean trustAll = false;
    private boolean verifyHost = true;

    public static final RegistryClientOptions create() {
        return new RegistryClientOptions();
    }

    public static final RegistryClientOptions create(String registryUrl) {
        return new RegistryClientOptions().registryUrl(registryUrl);
    }

    public static final RegistryClientOptions create(String registryUrl, Vertx vertx) {
        return new RegistryClientOptions().registryUrl(registryUrl).vertx(vertx);
    }

    private RegistryClientOptions() {
    }

    public String getRegistryUrl() {
        return this.registryUrl;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getScope() {
        return this.scope;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public WebClient getWebClient() {
        return this.webClient;
    }

    public boolean isRetryEnabled() {
        return this.retryEnabled;
    }

    public int getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public long getRetryDelayMs() {
        return this.retryDelayMs;
    }

    public double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    public long getMaxRetryDelayMs() {
        return this.maxRetryDelayMs;
    }

    public TrustStoreType getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String[] getPemCertPaths() {
        return this.pemCertPaths;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public boolean isVerifyHost() {
        return this.verifyHost;
    }

    public RegistryClientOptions registryUrl(String registryUrl) {
        this.registryUrl = registryUrl;
        return this;
    }

    public RegistryClientOptions basicAuth(String username, String password) {
        this.clearAuth();
        this.authType = AuthType.BASIC;
        this.username = username;
        this.password = password;
        return this;
    }

    public RegistryClientOptions oauth2(String tokenEndpoint, String clientId, String clientSecret) {
        this.clearAuth();
        return this.oauth2(tokenEndpoint, clientId, clientSecret, null);
    }

    public RegistryClientOptions oauth2(String tokenEndpoint, String clientId, String clientSecret, String scope) {
        this.clearAuth();
        this.authType = AuthType.OAUTH2;
        this.tokenEndpoint = tokenEndpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scope = scope;
        return this;
    }

    public RegistryClientOptions customWebClient(WebClient webClient) {
        this.clearAuth();
        this.authType = AuthType.CUSTOM_WEBCLIENT;
        this.webClient = webClient;
        return this;
    }

    private void clearAuth() {
        this.authType = AuthType.ANONYMOUS;
        this.username = null;
        this.password = null;
        this.tokenEndpoint = null;
        this.clientId = null;
        this.clientSecret = null;
        this.scope = null;
        this.webClient = null;
    }

    public RegistryClientOptions retry(boolean enabled, int maxAttempts, long initialDelayMs) {
        return this.retry(enabled, maxAttempts, initialDelayMs, 2.0, 10000L);
    }

    public RegistryClientOptions retry(boolean enabled, int maxAttempts, long initialDelayMs, double backoffMultiplier, long maxDelayMs) {
        if (enabled && maxAttempts <= 0) {
            throw new IllegalArgumentException("maxAttempts must be greater than 0 when retry is enabled");
        }
        if (enabled && initialDelayMs <= 0L) {
            throw new IllegalArgumentException("initialDelayMs must be greater than 0 when retry is enabled");
        }
        if (enabled && backoffMultiplier <= 1.0) {
            throw new IllegalArgumentException("backoffMultiplier must be greater than 1.0 when retry is enabled");
        }
        if (enabled && maxDelayMs <= 0L) {
            throw new IllegalArgumentException("maxDelayMs must be greater than 0 when retry is enabled");
        }
        this.retryEnabled = enabled;
        this.maxRetryAttempts = maxAttempts;
        this.retryDelayMs = initialDelayMs;
        this.backoffMultiplier = backoffMultiplier;
        this.maxRetryDelayMs = maxDelayMs;
        return this;
    }

    public RegistryClientOptions retry() {
        return this.retry(true, 3, 250L, 2.0, 10000L);
    }

    public RegistryClientOptions disableRetry() {
        return this.retry(false, 0, 0L, 1.0, 0L);
    }

    public RegistryClientOptions vertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public RegistryClientOptions trustStoreJks(String path, String password) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException("Trust store path cannot be null or empty");
        }
        this.clearTrustStore();
        this.trustStoreType = TrustStoreType.JKS;
        this.trustStorePath = path;
        this.trustStorePassword = password;
        return this;
    }

    public RegistryClientOptions trustStorePem(String ... certPaths) {
        if (certPaths == null || certPaths.length == 0) {
            throw new IllegalArgumentException("At least one PEM certificate path must be provided");
        }
        for (String path : certPaths) {
            if (path != null && !path.trim().isEmpty()) continue;
            throw new IllegalArgumentException("Certificate path cannot be null or empty");
        }
        this.clearTrustStore();
        this.trustStoreType = TrustStoreType.PEM;
        this.pemCertPaths = certPaths;
        return this;
    }

    public RegistryClientOptions trustAll(boolean trustAll) {
        this.trustAll = trustAll;
        return this;
    }

    public RegistryClientOptions verifyHost(boolean verifyHost) {
        this.verifyHost = verifyHost;
        return this;
    }

    public RegistryClientOptions clearTrustStore() {
        this.trustStoreType = TrustStoreType.NONE;
        this.trustStorePath = null;
        this.trustStorePassword = null;
        this.pemCertPaths = null;
        this.trustAll = false;
        return this;
    }

    public static enum AuthType {
        ANONYMOUS,
        BASIC,
        OAUTH2,
        CUSTOM_WEBCLIENT;

    }

    public static enum TrustStoreType {
        JKS,
        PEM,
        NONE;

    }
}

