/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.examples.sender;

import io.allune.quickfixj.spring.boot.starter.EnableQuickFixJServer;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import quickfix.Application;
import quickfix.ApplicationAdapter;
import quickfix.ConfigError;
import quickfix.Initiator;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.SessionSettings;
import quickfix.ThreadedSocketInitiator;

@EnableQuickFixJServer
@SpringBootApplication
public class AppServer {
    public static void main(String[] args) {
        SpringApplication.run(AppServer.class, (String[])args);
    }

    @Bean
    public Application clientApplication() {
        return new ApplicationAdapter();
    }

    @Bean
    public Initiator clientInitiator(Application clientApplication, MessageStoreFactory clientMessageStoreFactory, SessionSettings clientSessionSettings, LogFactory clientLogFactory, MessageFactory clientMessageFactory) throws ConfigError {
        return new ThreadedSocketInitiator(clientApplication, clientMessageStoreFactory, clientSessionSettings, clientLogFactory, clientMessageFactory);
    }
}

