/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.examples.sender;

import io.allune.quickfixj.spring.boot.starter.template.QuickFixJTemplate;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import quickfix.Acceptor;
import quickfix.Message;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SessionNotFound;
import quickfix.StringField;
import quickfix.field.AvgPx;
import quickfix.field.ClOrdID;
import quickfix.field.CumQty;
import quickfix.field.ExecID;
import quickfix.field.ExecType;
import quickfix.field.LeavesQty;
import quickfix.field.OnBehalfOfCompID;
import quickfix.field.OrdStatus;
import quickfix.field.OrdType;
import quickfix.field.OrderID;
import quickfix.field.OrderQty;
import quickfix.field.OrigClOrdID;
import quickfix.field.Product;
import quickfix.field.QuoteID;
import quickfix.field.QuoteReqID;
import quickfix.field.SettlDate;
import quickfix.field.SettlType;
import quickfix.field.Side;
import quickfix.field.Spread;
import quickfix.field.Symbol;
import quickfix.field.TransactTime;
import quickfix.fix41.OrderCancelRequest;
import quickfix.fix42.QuoteRequest;
import quickfix.fix44.ExecutionReport;
import quickfix.fix50.Quote;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class SenderController {
    private static final Map<String, Map<String, Message>> messageMap = SenderController.createMessageMap();
    private final QuickFixJTemplate quickFixJTemplate;
    private final Acceptor serverAcceptor;

    public SenderController(QuickFixJTemplate serverQuickFixJTemplate, Acceptor serverAcceptor) {
        this.quickFixJTemplate = serverQuickFixJTemplate;
        this.serverAcceptor = serverAcceptor;
    }

    private static HashMap<String, Map<String, Message>> createMessageMap() {
        HashMap<String, Map<String, Message>> stringMapHashMap = new HashMap<String, Map<String, Message>>();
        stringMapHashMap.put("FIX.4.1", SenderController.initialiseFix41MessageMap());
        stringMapHashMap.put("FIXT.1.1", SenderController.initialiseFix50MessageMap());
        return stringMapHashMap;
    }

    private static Map<String, Message> initialiseFix41MessageMap() {
        HashMap<String, Message> messageMap = new HashMap<String, Message>();
        messageMap.put("OrderCancelRequest", (Message)new OrderCancelRequest(new OrigClOrdID("123"), new ClOrdID("321"), new Symbol("LNUX"), new Side('1')));
        return messageMap;
    }

    private static Map<String, Message> initialiseFix50MessageMap() {
        HashMap<String, Message> messageMap = new HashMap<String, Message>();
        messageMap.put("Quote", (Message)new Quote(new QuoteID("123")));
        return messageMap;
    }

    @RequestMapping(value={"/send-message"})
    @ResponseStatus(value=HttpStatus.OK)
    public void sendMessage(@RequestParam String fixVersion, @RequestParam String messageType) {
        Map stringMessageMap = (Map)messageMap.get(fixVersion);
        Message message = (Message)stringMessageMap.get(messageType);
        message.setField(new StringField(58, "Text: " + UUID.randomUUID().toString()));
        SessionID sessionID = this.serverAcceptor.getSessions().stream().filter(id -> id.getBeginString().equals(fixVersion)).findFirst().orElseThrow(RuntimeException::new);
        this.quickFixJTemplate.send(message, sessionID);
    }

    @GetMapping(path={"/path1"})
    public ResponseEntity<?> getPath1() throws SessionNotFound {
        QuoteRequest quoteRequest = this.createQuoteRequest(UUID.randomUUID());
        SessionID sessionID = new SessionID("FIX.4.2", "EXEC", "BANZAI");
        Session.sendToTarget((Message)quoteRequest, (SessionID)sessionID);
        return ResponseEntity.ok((Object)"OK");
    }

    @GetMapping(path={"/path2"})
    public ResponseEntity<?> getPath2() throws SessionNotFound {
        QuoteRequest quoteRequest = this.createQuoteRequest(UUID.randomUUID());
        SessionID sessionID = new SessionID("FIX.4.2", "EXEC", "BANZAI");
        Session.sendToTarget((Message)quoteRequest, (SessionID)sessionID);
        return ResponseEntity.ok((Object)"OK");
    }

    @GetMapping(path={"/execution-report"})
    public ResponseEntity<?> executionReport() throws SessionNotFound {
        ExecutionReport executionReport = new ExecutionReport(new OrderID("3-2-805331618T-0-0"), new ExecID("3-2-805331618T-0-0"), new ExecType('F'), new OrdStatus('2'), new Side('1'), new LeavesQty(0.0), new CumQty(1000000.0), new AvgPx(5.57765));
        SessionID sessionID = new SessionID("FIX.4.4", "EXEC", "BANZAI");
        OnBehalfOfCompID onBehalfOfCompId = new OnBehalfOfCompID("FX");
        executionReport.set(new TransactTime());
        executionReport.set(new SettlType("0"));
        executionReport.set(new SettlDate("20201016"));
        executionReport.set(new OrderQty(1000000.0));
        executionReport.set(new Spread(0.0));
        executionReport.set(new OrdType('1'));
        executionReport.set(new Product(4));
        executionReport.set(new ClOrdID("3-2-805331618T-0-0"));
        executionReport.set(new Symbol("USD/BRL"));
        Session.sendToTarget((Message)executionReport, (SessionID)sessionID);
        return ResponseEntity.ok((Object)"OK");
    }

    private QuoteRequest createQuoteRequest(UUID operationId) {
        return new QuoteRequest(new QuoteReqID(operationId.toString()));
    }
}

