/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.messaging.test;

import io.aleph0.yap.core.Sink;
import io.aleph0.yap.messaging.core.FirehoseMetrics;
import io.aleph0.yap.messaging.core.FirehoseProducerWorker;
import io.aleph0.yap.messaging.core.Message;
import io.aleph0.yap.messaging.test.Scheduler;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFirehoseProducerWorker<T>
implements FirehoseProducerWorker<Message<T>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestFirehoseProducerWorker.class);
    private final AtomicLong receivedMetric = new AtomicLong(0L);
    private final Scheduler scheduler;
    private final Supplier<Message<T>> messageSupplier;

    public TestFirehoseProducerWorker(Supplier<Message<T>> messageSupplier) {
        this(Scheduler.defaultScheduler(), messageSupplier);
    }

    public TestFirehoseProducerWorker(Scheduler scheduler, Supplier<Message<T>> messageSupplier) {
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
        this.messageSupplier = Objects.requireNonNull(messageSupplier, "messageSupplier");
    }

    public void produce(Sink<Message<T>> sink) throws InterruptedException {
        try {
            Message<T> message = this.messageSupplier.get();
            while (message != null) {
                if (Thread.interrupted()) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedException();
                }
                Duration delay = this.scheduler.schedule();
                Thread.sleep(delay.toMillis());
                this.receivedMetric.incrementAndGet();
                sink.put(message);
                message = this.messageSupplier.get();
            }
        }
        catch (InterruptedException e) {
            LOGGER.atError().setCause((Throwable)e).log("Test firehose interrupted. Propagating...");
            Thread.currentThread().interrupt();
            throw new InterruptedException();
        }
    }

    public FirehoseMetrics checkMetrics() {
        long received = this.receivedMetric.get();
        return new FirehoseMetrics(received);
    }

    public FirehoseMetrics flushMetrics() {
        FirehoseMetrics result = this.checkMetrics();
        this.receivedMetric.set(0L);
        return result;
    }
}

