/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.messaging.test;

import java.time.Duration;
import java.util.Random;

@FunctionalInterface
public interface Scheduler {
    public static Scheduler defaultScheduler() {
        return Scheduler.defaultScheduler(new Random());
    }

    public static Scheduler defaultScheduler(Random rand) {
        return Scheduler.randomScheduler(rand, 80L, 40L);
    }

    public static Scheduler randomScheduler(Random rand, long base, long jitter) {
        if (rand == null) {
            throw new NullPointerException("rand");
        }
        if (base < 0L) {
            throw new IllegalArgumentException("base must be non-negative");
        }
        if (jitter < 0L) {
            throw new IllegalArgumentException("jitter must be non-negative");
        }
        if (jitter == 0L) {
            return () -> Duration.ofMillis(base);
        }
        return () -> Duration.ofMillis(base + rand.nextLong(jitter));
    }

    public Duration schedule();
}

