/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.security.csr;

import com.google.common.io.BaseEncoding;
import io.airlift.security.csr.SignatureAlgorithmIdentifier;
import java.util.Map;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.junit.jupiter.api.Test;

public class TestSignatureAlgorithmIdentifier {
    @Test
    public void test() throws Exception {
        int verifiedCount = 0;
        for (Map.Entry entry : SignatureAlgorithmIdentifier.getAllSignatureAlgorithmIdentifiers().entrySet()) {
            AlgorithmIdentifier algorithmIdentifier;
            SignatureAlgorithmIdentifier signatureAlgorithmIdentifier = (SignatureAlgorithmIdentifier)entry.getValue();
            Assertions.assertThat((String)signatureAlgorithmIdentifier.getName()).isEqualTo((String)entry.getKey());
            try {
                algorithmIdentifier = new DefaultSignatureAlgorithmIdentifierFinder().find((String)entry.getKey());
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            Assertions.assertThat((String)signatureAlgorithmIdentifier.getOid()).isEqualTo(algorithmIdentifier.getAlgorithm().getId());
            Assertions.assertThat((String)BaseEncoding.base16().encode(signatureAlgorithmIdentifier.getEncoded())).isEqualTo(BaseEncoding.base16().encode(algorithmIdentifier.getAlgorithm().getEncoded("DER")));
            Assertions.assertThat((Object)algorithmIdentifier).isEqualTo((Object)algorithmIdentifier);
            Assertions.assertThat((int)algorithmIdentifier.hashCode()).isEqualTo(algorithmIdentifier.hashCode());
            ++verifiedCount;
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)verifiedCount).as("Algorithm identifiers verified", new Object[0])).isGreaterThanOrEqualTo(10);
    }
}

