/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.security.csr;

import com.google.common.io.BaseEncoding;
import io.airlift.security.csr.CertificationRequestInfo;
import io.airlift.security.csr.SignatureAlgorithmIdentifier;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import javax.security.auth.x500.X500Principal;
import org.assertj.core.api.Assertions;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.junit.jupiter.api.Test;

public class TestCertificationRequestInfo {
    @Test
    public void test() throws Exception {
        String name = "C=country";
        KeyPairGenerator generator = KeyPairGenerator.getInstance("EC");
        generator.initialize(new ECGenParameterSpec("secp256r1"));
        KeyPair keyPair = generator.generateKeyPair();
        CertificationRequestInfo actualInfo = new CertificationRequestInfo(new X500Principal(name), keyPair.getPublic());
        Assertions.assertThat((Object)actualInfo.getPublicKey()).isEqualTo((Object)keyPair.getPublic());
        Assertions.assertThat((String)actualInfo.getSubject().getName()).isEqualTo(name);
        Assertions.assertThat((Object)actualInfo).isEqualTo((Object)actualInfo);
        Assertions.assertThat((int)actualInfo.hashCode()).isEqualTo(actualInfo.hashCode());
        org.bouncycastle.asn1.pkcs.CertificationRequestInfo expectedInfo = new org.bouncycastle.asn1.pkcs.CertificationRequestInfo(new X500Name(name), SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded()), (ASN1Set)new DERSet());
        Assertions.assertThat((String)BaseEncoding.base16().encode(actualInfo.getEncoded())).isEqualTo(BaseEncoding.base16().encode(expectedInfo.getEncoded("DER")));
        SignatureAlgorithmIdentifier signatureAlgorithmIdentifier = SignatureAlgorithmIdentifier.findSignatureAlgorithmIdentifier((String)"SHA256withECDSA");
        byte[] actualSignature = actualInfo.sign(signatureAlgorithmIdentifier, keyPair.getPrivate());
        Signature signature = Signature.getInstance(signatureAlgorithmIdentifier.getName());
        signature.initVerify(keyPair.getPublic());
        signature.update(actualInfo.getEncoded());
        Assertions.assertThat((boolean)signature.verify(actualSignature)).isTrue();
    }
}

