/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.security.jwks;

import io.airlift.security.jwks.JwkPublicKey;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.util.Objects;

public class JwkRsaPublicKey
implements JwkPublicKey,
RSAPublicKey {
    private final String keyId;
    private final BigInteger modulus;
    private final BigInteger exponent;

    public JwkRsaPublicKey(String keyId, BigInteger exponent, BigInteger modulus) {
        this.keyId = Objects.requireNonNull(keyId, "keyId is null");
        this.exponent = Objects.requireNonNull(exponent, "exponent is null");
        this.modulus = Objects.requireNonNull(modulus, "modulus is null");
    }

    @Override
    public String getKeyId() {
        return this.keyId;
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.exponent;
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public String getFormat() {
        return "JWK";
    }

    @Override
    public byte[] getEncoded() {
        throw new UnsupportedOperationException();
    }
}

