/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.node;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.common.net.InetAddresses;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.node.NodeInfo;
import io.airlift.node.NodeModule;
import java.io.File;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestNodeModule {
    @Test
    public void testDefaultConfig() throws UnknownHostException {
        long testStartTime = System.currentTimeMillis();
        ConfigurationFactory configFactory = new ConfigurationFactory((Map)ImmutableMap.of((Object)"node.environment", (Object)"environment"));
        Injector injector = Guice.createInjector((Module[])new Module[]{new NodeModule(), new ConfigurationModule(configFactory)});
        NodeInfo nodeInfo = (NodeInfo)injector.getInstance(NodeInfo.class);
        Assertions.assertThat((Object)nodeInfo).isNotNull();
        Assertions.assertThat((String)nodeInfo.getEnvironment()).isEqualTo("environment");
        Assertions.assertThat((String)nodeInfo.getPool()).isEqualTo("general");
        Assertions.assertThat((String)nodeInfo.getNodeId()).isNotNull();
        Assertions.assertThat((String)nodeInfo.getLocation()).isNotNull();
        Assertions.assertThat((String)nodeInfo.getBinarySpec()).isNull();
        Assertions.assertThat((String)nodeInfo.getConfigSpec()).isNull();
        Assertions.assertThat((String)nodeInfo.getInstanceId()).isNotNull();
        Assertions.assertThat((String)nodeInfo.getNodeId()).isNotEqualTo((Object)nodeInfo.getInstanceId());
        Assertions.assertThat((String)nodeInfo.getInternalAddress()).isNotNull();
        Assertions.assertThat((boolean)InetAddress.getByName(nodeInfo.getInternalAddress()).isAnyLocalAddress()).isFalse();
        Assertions.assertThat((Object)nodeInfo.getBindIp()).isNotNull();
        Assertions.assertThat((boolean)nodeInfo.getBindIp().isAnyLocalAddress()).isTrue();
        Assertions.assertThat((long)nodeInfo.getStartTime()).isGreaterThanOrEqualTo(testStartTime);
        Assertions.assertThat((int)nodeInfo.getAnnotations().size()).isEqualTo(0);
        Assertions.assertThat((String)nodeInfo.toString()).isNotNull();
    }

    @Test
    public void testFullConfig() throws URISyntaxException {
        long testStartTime = System.currentTimeMillis();
        String environment = "environment";
        String pool = "pool";
        String nodeId = "nodeId";
        String location = "location";
        String binarySpec = "binary";
        String configSpec = "config";
        String publicAddress = "public";
        File annotationFile = new File(Resources.getResource((String)"annotations.properties").toURI());
        ConfigurationFactory configFactory = new ConfigurationFactory((Map)ImmutableMap.builder().put((Object)"node.environment", (Object)environment).put((Object)"node.pool", (Object)pool).put((Object)"node.id", (Object)nodeId).put((Object)"node.internal-address", (Object)publicAddress).put((Object)"node.location", (Object)location).put((Object)"node.binary-spec", (Object)binarySpec).put((Object)"node.config-spec", (Object)configSpec).put((Object)"node.annotation-file", (Object)annotationFile.getAbsolutePath()).build());
        Injector injector = Guice.createInjector((Module[])new Module[]{new NodeModule(), new ConfigurationModule(configFactory)});
        NodeInfo nodeInfo = (NodeInfo)injector.getInstance(NodeInfo.class);
        Assertions.assertThat((Object)nodeInfo).isNotNull();
        Assertions.assertThat((String)nodeInfo.getEnvironment()).isEqualTo(environment);
        Assertions.assertThat((String)nodeInfo.getPool()).isEqualTo(pool);
        Assertions.assertThat((String)nodeInfo.getNodeId()).isEqualTo(nodeId);
        Assertions.assertThat((String)nodeInfo.getLocation()).isEqualTo(location);
        Assertions.assertThat((String)nodeInfo.getBinarySpec()).isEqualTo(binarySpec);
        Assertions.assertThat((String)nodeInfo.getConfigSpec()).isEqualTo(configSpec);
        Assertions.assertThat((String)nodeInfo.getInstanceId()).isNotNull();
        Assertions.assertThat((String)nodeInfo.getNodeId()).isNotEqualTo((Object)nodeInfo.getInstanceId());
        Assertions.assertThat((String)nodeInfo.getInternalAddress()).isEqualTo(publicAddress);
        Assertions.assertThat((Object)nodeInfo.getBindIp()).isEqualTo((Object)InetAddresses.forString((String)"0.0.0.0"));
        Assertions.assertThat((long)nodeInfo.getStartTime()).isGreaterThanOrEqualTo(testStartTime);
        Assertions.assertThat((Map)nodeInfo.getAnnotations()).isEqualTo(Map.of("team", "a", "region", "b"));
        Assertions.assertThat((String)nodeInfo.toString()).isNotNull();
    }
}

