/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.node.testing;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.node.NodeInfo;
import io.airlift.node.testing.TestingNodeModule;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTestingNodeModule {
    @Test
    public void testTestingNode() throws UnknownHostException {
        long testStartTime = System.currentTimeMillis();
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestingNodeModule()});
        NodeInfo nodeInfo = (NodeInfo)injector.getInstance(NodeInfo.class);
        Assertions.assertThat((Object)nodeInfo).isNotNull();
        Assertions.assertThat((String)nodeInfo.getEnvironment()).matches((CharSequence)"test\\d+");
        Assertions.assertThat((String)nodeInfo.getPool()).isEqualTo("general");
        Assertions.assertThat((String)nodeInfo.getNodeId()).isNotNull();
        Assertions.assertThat((String)nodeInfo.getLocation()).isNotNull();
        Assertions.assertThat((String)nodeInfo.getBinarySpec()).isNull();
        Assertions.assertThat((String)nodeInfo.getConfigSpec()).isNull();
        Assertions.assertThat((String)nodeInfo.getInstanceId()).isNotNull();
        Assertions.assertThat((String)nodeInfo.getNodeId()).isNotEqualTo((Object)nodeInfo.getInstanceId());
        Assertions.assertThat((String)nodeInfo.getInternalAddress()).isEqualTo("127.0.0.1");
        Assertions.assertThat((Object)nodeInfo.getBindIp()).isEqualTo((Object)InetAddress.getByName(nodeInfo.getInternalAddress()));
        Assertions.assertThat((String)nodeInfo.getExternalAddress()).isEqualTo("127.0.0.1");
        Assertions.assertThat((long)nodeInfo.getStartTime()).isGreaterThanOrEqualTo(testStartTime);
        Assertions.assertThat((String)nodeInfo.toString()).isNotNull();
    }

    @Test
    public void testTestingNodeExplicitEnvironment() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestingNodeModule("foo")});
        NodeInfo nodeInfo = (NodeInfo)injector.getInstance(NodeInfo.class);
        Assertions.assertThat((Object)nodeInfo).isNotNull();
        Assertions.assertThat((String)nodeInfo.getEnvironment()).isEqualTo("foo");
    }

    @Test
    public void testTestingNodePresentEnvironment() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestingNodeModule(Optional.of("foo"))});
        NodeInfo nodeInfo = (NodeInfo)injector.getInstance(NodeInfo.class);
        Assertions.assertThat((Object)nodeInfo).isNotNull();
        Assertions.assertThat((String)nodeInfo.getEnvironment()).isEqualTo("foo");
    }

    @Test
    public void testTestingNodeAbsentEnvironment() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestingNodeModule(Optional.empty())});
        NodeInfo nodeInfo = (NodeInfo)injector.getInstance(NodeInfo.class);
        Assertions.assertThat((Object)nodeInfo).isNotNull();
        Assertions.assertThat((String)nodeInfo.getEnvironment()).matches((CharSequence)"test\\d+");
    }
}

