/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.node;

import com.google.common.net.InetAddresses;
import io.airlift.node.NodeConfig;
import io.airlift.node.NodeInfo;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestNodeInfo {
    public static final String ENVIRONMENT = "environment_1234";
    public static final String POOL = "pool_1234";

    @Test
    public void testBasicNodeInfo() {
        long testStartTime = System.currentTimeMillis();
        String nodeId = "nodeId";
        String location = "location";
        String binarySpec = "binary";
        String configSpec = "config";
        String internalIp = "10.0.0.22";
        InetAddress bindIp = InetAddresses.forString((String)"10.0.0.33");
        String externalAddress = "external";
        NodeInfo nodeInfo = new NodeInfo(ENVIRONMENT, POOL, nodeId, internalIp, bindIp, externalAddress, location, binarySpec, configSpec, NodeConfig.AddressSource.IP, null, false);
        Assertions.assertThat((String)nodeInfo.getEnvironment()).isEqualTo(ENVIRONMENT);
        Assertions.assertThat((String)nodeInfo.getPool()).isEqualTo(POOL);
        Assertions.assertThat((String)nodeInfo.getNodeId()).isEqualTo(nodeId);
        Assertions.assertThat((String)nodeInfo.getLocation()).isEqualTo(location);
        Assertions.assertThat((String)nodeInfo.getBinarySpec()).isEqualTo(binarySpec);
        Assertions.assertThat((String)nodeInfo.getConfigSpec()).isEqualTo(configSpec);
        Assertions.assertThat((String)nodeInfo.getInstanceId()).isNotNull();
        Assertions.assertThat((String)nodeInfo.getNodeId()).isNotEqualTo((Object)nodeInfo.getInstanceId());
        Assertions.assertThat((String)nodeInfo.getInternalAddress()).isEqualTo(internalIp);
        Assertions.assertThat((String)nodeInfo.getExternalAddress()).isEqualTo(externalAddress);
        Assertions.assertThat((Object)nodeInfo.getBindIp()).isEqualTo((Object)bindIp);
        Assertions.assertThat((long)nodeInfo.getStartTime()).isGreaterThanOrEqualTo(testStartTime);
        Assertions.assertThat((int)nodeInfo.getAnnotations().size()).isEqualTo(0);
        Assertions.assertThat((String)nodeInfo.toString()).isNotNull();
    }

    @Test
    public void testDefaultAddresses() {
        NodeInfo nodeInfo = new NodeInfo(ENVIRONMENT, POOL, "nodeInfo", "10.0.0.22", null, null, null, null, null, NodeConfig.AddressSource.IP, null, false);
        Assertions.assertThat((String)nodeInfo.getExternalAddress()).isEqualTo("10.0.0.22");
        Assertions.assertThat((Object)nodeInfo.getBindIp()).isEqualTo((Object)InetAddresses.forString((String)"0.0.0.0"));
    }

    @Test
    public void testIpDiscovery() {
        NodeInfo nodeInfo = new NodeInfo(ENVIRONMENT, POOL, "nodeInfo", null, null, null, null, null, null, NodeConfig.AddressSource.IP, null, false);
        Assertions.assertThat((String)nodeInfo.getInternalAddress()).isNotNull();
        Assertions.assertThat((Object)nodeInfo.getBindIp()).isEqualTo((Object)InetAddresses.forString((String)"0.0.0.0"));
        Assertions.assertThat((String)nodeInfo.getExternalAddress()).isEqualTo(nodeInfo.getInternalAddress());
    }

    @Test
    public void testIpDiscoveryIpv6Preferred() {
        NodeInfo nodeInfo = new NodeInfo(ENVIRONMENT, POOL, "nodeInfo", null, null, null, null, null, null, NodeConfig.AddressSource.IP, null, true);
        Assertions.assertThat((String)nodeInfo.getInternalAddress()).isNotNull();
        Assertions.assertThat((Object)nodeInfo.getBindIp()).isEqualTo((Object)InetAddresses.forString((String)"0.0.0.0"));
        Assertions.assertThat((String)nodeInfo.getExternalAddress()).isEqualTo(nodeInfo.getInternalAddress());
    }

    @Test
    public void testHostnameDiscovery() throws UnknownHostException {
        NodeInfo nodeInfo = new NodeInfo(ENVIRONMENT, POOL, "nodeInfo", null, null, null, null, null, null, NodeConfig.AddressSource.HOSTNAME, null, false);
        Assertions.assertThat((String)nodeInfo.getInternalAddress()).isNotNull();
        Assertions.assertThat((Object)nodeInfo.getBindIp()).isEqualTo((Object)InetAddresses.forString((String)"0.0.0.0"));
        Assertions.assertThat((String)nodeInfo.getExternalAddress()).isEqualTo(InetAddress.getLocalHost().getHostName());
    }

    @Test
    public void testFqdnDiscovery() throws UnknownHostException {
        NodeInfo nodeInfo = new NodeInfo(ENVIRONMENT, POOL, "nodeInfo", null, null, null, null, null, null, NodeConfig.AddressSource.FQDN, null, false);
        Assertions.assertThat((String)nodeInfo.getInternalAddress()).isNotNull();
        Assertions.assertThat((Object)nodeInfo.getBindIp()).isEqualTo((Object)InetAddresses.forString((String)"0.0.0.0"));
        Assertions.assertThat((String)nodeInfo.getExternalAddress()).isEqualTo(InetAddress.getLocalHost().getCanonicalHostName());
    }

    @Test
    public void testInvalidNodeId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new NodeInfo(ENVIRONMENT, POOL, "abc/123", null, null, null, null, null, null, NodeConfig.AddressSource.IP, null, false)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("nodeId .*");
    }

    @Test
    public void testInvalidEnvironment() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new NodeInfo("ENV", POOL, null, null, null, null, null, null, null, NodeConfig.AddressSource.IP, null, false)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("environment .*");
    }

    @Test
    public void testInvalidPool() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new NodeInfo(ENVIRONMENT, "POOL", null, null, null, null, null, null, null, NodeConfig.AddressSource.IP, null, false)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("pool .*");
    }

    @Test
    public void testInvalidAnnotationFile() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new NodeInfo(ENVIRONMENT, POOL, "nodeInfo", null, null, null, null, null, null, NodeConfig.AddressSource.IP, "invalid.file", false)).isInstanceOf(UncheckedIOException.class)).hasMessageMatching("java.io.FileNotFoundException: invalid.file \\(No such file or directory\\)");
    }
}

