/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.node;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.common.net.InetAddresses;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.node.NodeConfig;
import io.airlift.testing.ValidationAssertions;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.UUID;
import org.junit.jupiter.api.Test;

public class TestNodeConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((NodeConfig)ConfigAssertions.recordDefaults(NodeConfig.class)).setEnvironment(null).setPool("general").setNodeId(null).setNodeInternalAddress(null).setNodeBindIp((String)null).setNodeExternalAddress(null).setLocation(null).setBinarySpec(null).setConfigSpec(null).setInternalAddressSource(NodeConfig.AddressSource.IP).setAnnotationFile(null).setPreferIpv6Address(false));
    }

    @Test
    public void testExplicitPropertyMappings() throws URISyntaxException {
        File annotationFile = new File(Resources.getResource((String)"annotations.properties").toURI());
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"node.environment", (Object)"environment").put((Object)"node.pool", (Object)"pool").put((Object)"node.id", (Object)"nodeId").put((Object)"node.internal-address", (Object)"internal").put((Object)"node.bind-ip", (Object)"10.11.12.13").put((Object)"node.external-address", (Object)"external").put((Object)"node.location", (Object)"location").put((Object)"node.binary-spec", (Object)"binary").put((Object)"node.config-spec", (Object)"config").put((Object)"node.internal-address-source", (Object)"HOSTNAME").put((Object)"node.annotation-file", (Object)annotationFile.getAbsolutePath()).put((Object)"node.prefer-ipv6-address", (Object)"true").build();
        NodeConfig expected = new NodeConfig().setEnvironment("environment").setPool("pool").setNodeId("nodeId").setNodeInternalAddress("internal").setNodeBindIp(InetAddresses.forString((String)"10.11.12.13")).setNodeExternalAddress("external").setLocation("location").setBinarySpec("binary").setConfigSpec("config").setInternalAddressSource(NodeConfig.AddressSource.HOSTNAME).setAnnotationFile(annotationFile.getAbsolutePath()).setPreferIpv6Address(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testValidations() {
        ValidationAssertions.assertValidates((Object)new NodeConfig().setEnvironment("test").setNodeId(UUID.randomUUID().toString()));
        ValidationAssertions.assertFailsValidation((Object)new NodeConfig().setNodeId("abc/123"), (String)"nodeId", (String)"should match [A-Za-z0-9][_A-Za-z0-9-]*", Pattern.class);
        ValidationAssertions.assertFailsValidation((Object)new NodeConfig(), (String)"environment", (String)"must not be null", NotNull.class);
        ValidationAssertions.assertFailsValidation((Object)new NodeConfig().setEnvironment("FOO"), (String)"environment", (String)"should match [a-z0-9][_a-z0-9]*", Pattern.class);
        ValidationAssertions.assertFailsValidation((Object)new NodeConfig().setPool("FOO"), (String)"pool", (String)"should match [a-z0-9][_a-z0-9]*", Pattern.class);
    }
}

