/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.node;

import com.google.common.net.InetAddresses;
import io.airlift.node.AddressToHostname;
import java.net.InetAddress;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAddressSource {
    @Test
    public void testIpEncoding() {
        TestAddressSource.verifyEncoding("127.0.0.1", "127-0-0-1.ip");
        TestAddressSource.verifyEncoding("1.2.3.4", "1-2-3-4.ip");
        TestAddressSource.verifyEncoding("2001:db8:85a3::8a2e:370:7334", "x2001-db8-85a3--8a2e-370-7334.ip");
        TestAddressSource.verifyEncoding("2001:db8:85a3:0000::8a2e:0370:7334", "x2001-db8-85a3--8a2e-370-7334.ip");
        TestAddressSource.verifyEncoding("::1", "x--1.ip");
    }

    private static void verifyEncoding(String addressString, String encodedHostname) {
        Assertions.assertThat((String)AddressToHostname.encodeAddressAsHostname((InetAddress)InetAddresses.forString((String)addressString))).isEqualTo(encodedHostname);
        Assertions.assertThat((Optional)AddressToHostname.tryDecodeHostnameToAddress((String)encodedHostname)).isEqualTo(Optional.of(InetAddresses.forString((String)addressString)));
    }
}

