/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.node.testing;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.node.NodeInfo;
import io.airlift.node.testing.TestingNodeModule;
import io.airlift.testing.Assertions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTestingNodeModule {
    @Test
    public void testTestingNode() throws UnknownHostException {
        long testStartTime = System.currentTimeMillis();
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestingNodeModule()});
        NodeInfo nodeInfo = (NodeInfo)injector.getInstance(NodeInfo.class);
        Assert.assertNotNull((Object)nodeInfo);
        Assert.assertTrue((boolean)nodeInfo.getEnvironment().matches("test\\d+"));
        Assert.assertEquals((String)nodeInfo.getPool(), (String)"general");
        Assert.assertNotNull((Object)nodeInfo.getNodeId());
        Assert.assertNotNull((Object)nodeInfo.getLocation());
        Assert.assertNull((Object)nodeInfo.getBinarySpec());
        Assert.assertNull((Object)nodeInfo.getConfigSpec());
        Assert.assertNotNull((Object)nodeInfo.getInstanceId());
        Assertions.assertNotEquals((Object)nodeInfo.getNodeId(), (Object)nodeInfo.getInstanceId());
        Assert.assertEquals((String)nodeInfo.getInternalAddress(), (String)"127.0.0.1");
        Assert.assertEquals((Object)nodeInfo.getBindIp(), (Object)InetAddress.getByName(nodeInfo.getInternalAddress()));
        Assert.assertEquals((String)nodeInfo.getExternalAddress(), (String)"127.0.0.1");
        Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(nodeInfo.getStartTime()), (Comparable)Long.valueOf(testStartTime));
        Assert.assertNotNull((Object)nodeInfo.toString());
    }

    @Test
    public void testTestingNodeExplicitEnvironment() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestingNodeModule("foo")});
        NodeInfo nodeInfo = (NodeInfo)injector.getInstance(NodeInfo.class);
        Assert.assertNotNull((Object)nodeInfo);
        Assert.assertEquals((String)nodeInfo.getEnvironment(), (String)"foo");
    }

    @Test
    public void testTestingNodePresentEnvironment() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestingNodeModule(Optional.of("foo"))});
        NodeInfo nodeInfo = (NodeInfo)injector.getInstance(NodeInfo.class);
        Assert.assertNotNull((Object)nodeInfo);
        Assert.assertEquals((String)nodeInfo.getEnvironment(), (String)"foo");
    }

    @Test
    public void testTestingNodeAbsentEnvironment() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestingNodeModule(Optional.empty())});
        NodeInfo nodeInfo = (NodeInfo)injector.getInstance(NodeInfo.class);
        Assert.assertNotNull((Object)nodeInfo);
        Assert.assertTrue((boolean)nodeInfo.getEnvironment().matches("test\\d+"));
    }
}

