/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.node;

import com.google.common.net.InetAddresses;
import io.airlift.node.NodeConfig;
import io.airlift.node.NodeInfo;
import io.airlift.testing.Assertions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNodeInfo {
    public static final String ENVIRONMENT = "environment_1234";
    public static final String POOL = "pool_1234";

    @Test
    public void testBasicNodeInfo() {
        long testStartTime = System.currentTimeMillis();
        String nodeId = "nodeId";
        String location = "location";
        String binarySpec = "binary";
        String configSpec = "config";
        String internalIp = "10.0.0.22";
        InetAddress bindIp = InetAddresses.forString((String)"10.0.0.33");
        String externalAddress = "external";
        NodeInfo nodeInfo = new NodeInfo(ENVIRONMENT, POOL, nodeId, internalIp, bindIp, externalAddress, location, binarySpec, configSpec, NodeConfig.AddressSource.IP);
        Assert.assertEquals((String)nodeInfo.getEnvironment(), (String)ENVIRONMENT);
        Assert.assertEquals((String)nodeInfo.getPool(), (String)POOL);
        Assert.assertEquals((String)nodeInfo.getNodeId(), (String)nodeId);
        Assert.assertEquals((String)nodeInfo.getLocation(), (String)location);
        Assert.assertEquals((String)nodeInfo.getBinarySpec(), (String)binarySpec);
        Assert.assertEquals((String)nodeInfo.getConfigSpec(), (String)configSpec);
        Assert.assertNotNull((Object)nodeInfo.getInstanceId());
        Assertions.assertNotEquals((Object)nodeInfo.getNodeId(), (Object)nodeInfo.getInstanceId());
        Assert.assertEquals((String)nodeInfo.getInternalAddress(), (String)internalIp);
        Assert.assertEquals((String)nodeInfo.getExternalAddress(), (String)externalAddress);
        Assert.assertEquals((Object)nodeInfo.getBindIp(), (Object)bindIp);
        Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(nodeInfo.getStartTime()), (Comparable)Long.valueOf(testStartTime));
        Assert.assertNotNull((Object)nodeInfo.toString());
    }

    @Test
    public void testDefaultAddresses() {
        NodeInfo nodeInfo = new NodeInfo(ENVIRONMENT, POOL, "nodeInfo", "10.0.0.22", null, null, null, null, null, NodeConfig.AddressSource.IP);
        Assert.assertEquals((String)nodeInfo.getExternalAddress(), (String)"10.0.0.22");
        Assert.assertEquals((Object)nodeInfo.getBindIp(), (Object)InetAddresses.forString((String)"0.0.0.0"));
    }

    @Test
    public void testIpDiscovery() throws UnknownHostException {
        NodeInfo nodeInfo = new NodeInfo(ENVIRONMENT, POOL, "nodeInfo", null, null, null, null, null, null, NodeConfig.AddressSource.IP);
        Assert.assertNotNull((Object)nodeInfo.getInternalAddress());
        Assert.assertEquals((Object)nodeInfo.getBindIp(), (Object)InetAddresses.forString((String)"0.0.0.0"));
        Assert.assertEquals((String)nodeInfo.getExternalAddress(), (String)nodeInfo.getInternalAddress());
    }

    @Test
    public void testHostnameDiscovery() throws UnknownHostException {
        NodeInfo nodeInfo = new NodeInfo(ENVIRONMENT, POOL, "nodeInfo", null, null, null, null, null, null, NodeConfig.AddressSource.HOSTNAME);
        Assert.assertNotNull((Object)nodeInfo.getInternalAddress());
        Assert.assertEquals((Object)nodeInfo.getBindIp(), (Object)InetAddresses.forString((String)"0.0.0.0"));
        Assert.assertEquals((String)nodeInfo.getExternalAddress(), (String)InetAddress.getLocalHost().getHostName());
    }

    @Test
    public void testFqdnDiscovery() throws UnknownHostException {
        NodeInfo nodeInfo = new NodeInfo(ENVIRONMENT, POOL, "nodeInfo", null, null, null, null, null, null, NodeConfig.AddressSource.FQDN);
        Assert.assertNotNull((Object)nodeInfo.getInternalAddress());
        Assert.assertEquals((Object)nodeInfo.getBindIp(), (Object)InetAddresses.forString((String)"0.0.0.0"));
        Assert.assertEquals((String)nodeInfo.getExternalAddress(), (String)InetAddress.getLocalHost().getCanonicalHostName());
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="nodeId .*")
    public void testInvalidNodeId() {
        new NodeInfo(ENVIRONMENT, POOL, "abc/123", null, null, null, null, null, null, NodeConfig.AddressSource.IP);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="environment .*")
    public void testInvalidEnvironment() {
        new NodeInfo("ENV", POOL, null, null, null, null, null, null, null, NodeConfig.AddressSource.IP);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="pool .*")
    public void testInvalidPool() {
        new NodeInfo(ENVIRONMENT, "POOL", null, null, null, null, null, null, null, NodeConfig.AddressSource.IP);
    }
}

