/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.airlift.json.ObjectMapperProvider;
import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLimits {
    @Test
    public void testNameLimitDefaultJsonFactory() throws IOException {
        this.testNameLengthLimit(new ObjectMapperProvider());
    }

    @Test
    public void testNameLimitCustomJsonFactory() throws IOException {
        JsonFactory myJsonFactory = new JsonFactory();
        this.testNameLengthLimit(new ObjectMapperProvider(myJsonFactory));
    }

    private void testNameLengthLimit(ObjectMapperProvider objectMapperProvider) throws IOException {
        ObjectMapper objectMapper = objectMapperProvider.get();
        String longName = Strings.repeat((String)"a", (int)100000);
        String content = String.format("{ \"%s\" : \"value\" }", longName);
        JsonNode jsonNode = objectMapper.reader().readTree(content);
        Assertions.assertThat((boolean)jsonNode.has(longName)).isTrue();
        Assertions.assertThat((String)jsonNode.findValue(longName).asText()).isEqualTo("value");
    }

    @Test
    public void testStringLimitDefaultJsonFactory() throws IOException {
        this.testNameLengthLimit(new ObjectMapperProvider());
    }

    @Test
    public void testStringLimitCustomJsonFactory() throws IOException {
        JsonFactory myJsonFactory = new JsonFactory();
        this.testNameLengthLimit(new ObjectMapperProvider(myJsonFactory));
    }

    private void testStringLengthLimit(ObjectMapperProvider objectMapperProvider) throws IOException {
        ObjectMapper objectMapper = objectMapperProvider.get();
        String longValue = Strings.repeat((String)"a", (int)100000);
        String content = String.format("{ \"key\" : \"%s\" }", longValue);
        JsonNode jsonNode = objectMapper.reader().readTree(content);
        Assertions.assertThat((String)jsonNode.findValue("key").asText()).isEqualTo(longValue);
    }
}

