/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import io.airlift.json.ImmutablePerson;
import io.airlift.json.JsonCodec;
import io.airlift.json.Person;
import io.airlift.json.RecordAutoDetectModule;
import io.airlift.json.Vehicle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJsonCodec {
    @Test
    public void testJsonCodec() {
        JsonCodec jsonCodec = JsonCodec.jsonCodec(Person.class);
        Person.validatePersonJsonCodec((JsonCodec<Person>)jsonCodec);
        JsonCodec vehicleJsonCodec = JsonCodec.jsonCodec(Vehicle.class);
        Vehicle.validateVehicleJsonCodec((JsonCodec<Vehicle>)vehicleJsonCodec);
    }

    @Test
    public void testListJsonCodec() {
        JsonCodec jsonCodec = JsonCodec.listJsonCodec(Person.class);
        Person.validatePersonListJsonCodec((JsonCodec<List<Person>>)jsonCodec);
        JsonCodec vehicleJsonCodec = JsonCodec.listJsonCodec(Vehicle.class);
        Vehicle.validateVehicleListJsonCodec((JsonCodec<List<Vehicle>>)vehicleJsonCodec);
    }

    @Test
    public void testListJsonCodecFromJsonCodec() {
        JsonCodec jsonCodec = JsonCodec.listJsonCodec((JsonCodec)JsonCodec.jsonCodec(Person.class));
        Person.validatePersonListJsonCodec((JsonCodec<List<Person>>)jsonCodec);
        JsonCodec vehicleJsonCodec = JsonCodec.listJsonCodec((JsonCodec)JsonCodec.jsonCodec(Vehicle.class));
        Vehicle.validateVehicleListJsonCodec((JsonCodec<List<Vehicle>>)vehicleJsonCodec);
    }

    @Test
    public void testTypeTokenList() {
        JsonCodec jsonCodec = JsonCodec.jsonCodec((TypeToken)new TypeToken<List<Person>>(){});
        Person.validatePersonListJsonCodec((JsonCodec<List<Person>>)jsonCodec);
        JsonCodec vehicleJsonCodec = JsonCodec.jsonCodec((TypeToken)new TypeToken<List<Vehicle>>(){});
        Vehicle.validateVehicleListJsonCodec((JsonCodec<List<Vehicle>>)vehicleJsonCodec);
    }

    @Test
    public void testListNullValues() {
        JsonCodec jsonCodec = JsonCodec.listJsonCodec(String.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add(null);
        list.add("abc");
        Assertions.assertThat((List)((List)jsonCodec.fromJson(jsonCodec.toJson(list)))).isEqualTo(list);
    }

    @Test
    public void testMapJsonCodec() {
        JsonCodec jsonCodec = JsonCodec.mapJsonCodec(String.class, Person.class);
        Person.validatePersonMapJsonCodec((JsonCodec<Map<String, Person>>)jsonCodec);
        JsonCodec vehicleJsonCodec = JsonCodec.mapJsonCodec(String.class, Vehicle.class);
        Vehicle.validateVehicleMapJsonCodec((JsonCodec<Map<String, Vehicle>>)vehicleJsonCodec);
    }

    @Test
    public void testMapJsonCodecFromJsonCodec() {
        JsonCodec jsonCodec = JsonCodec.mapJsonCodec(String.class, (JsonCodec)JsonCodec.jsonCodec(Person.class));
        Person.validatePersonMapJsonCodec((JsonCodec<Map<String, Person>>)jsonCodec);
        JsonCodec vehicleJsonCodec = JsonCodec.mapJsonCodec(String.class, (JsonCodec)JsonCodec.jsonCodec(Vehicle.class));
        Vehicle.validateVehicleMapJsonCodec((JsonCodec<Map<String, Vehicle>>)vehicleJsonCodec);
    }

    @Test
    public void testTypeLiteralMap() {
        JsonCodec jsonCodec = JsonCodec.jsonCodec((TypeToken)new TypeToken<Map<String, Person>>(){});
        Person.validatePersonMapJsonCodec((JsonCodec<Map<String, Person>>)jsonCodec);
        JsonCodec vehicleJsonCodec = JsonCodec.jsonCodec((TypeToken)new TypeToken<Map<String, Vehicle>>(){});
        Vehicle.validateVehicleMapJsonCodec((JsonCodec<Map<String, Vehicle>>)vehicleJsonCodec);
    }

    @Test
    public void testMapNullValues() {
        JsonCodec jsonCodec = JsonCodec.mapJsonCodec(String.class, String.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("x", null);
        map.put("y", "abc");
        Assertions.assertThat((Map)((Map)jsonCodec.fromJson(jsonCodec.toJson(map)))).isEqualTo(map);
    }

    @Test
    public void testImmutableJsonCodec() {
        JsonCodec jsonCodec = JsonCodec.jsonCodec(ImmutablePerson.class);
        ImmutablePerson.validatePersonJsonCodec((JsonCodec<ImmutablePerson>)jsonCodec);
    }

    @Test
    public void testAsymmetricJsonCodec() {
        JsonCodec jsonCodec = JsonCodec.jsonCodec(ImmutablePerson.class);
        ImmutablePerson immutablePerson = (ImmutablePerson)jsonCodec.fromJson("{ \"notWritable\": \"foo\" }");
        Assertions.assertThat((String)immutablePerson.getNotWritable()).isNull();
    }

    @Test
    public void testImmutableListJsonCodec() {
        JsonCodec jsonCodec = JsonCodec.listJsonCodec(ImmutablePerson.class);
        ImmutablePerson.validatePersonListJsonCodec((JsonCodec<List<ImmutablePerson>>)jsonCodec);
    }

    @Test
    public void testImmutableListJsonCodecFromJsonCodec() {
        JsonCodec jsonCodec = JsonCodec.listJsonCodec((JsonCodec)JsonCodec.jsonCodec(ImmutablePerson.class));
        ImmutablePerson.validatePersonListJsonCodec((JsonCodec<List<ImmutablePerson>>)jsonCodec);
    }

    @Test
    public void testImmutableTypeTokenList() {
        JsonCodec jsonCodec = JsonCodec.jsonCodec((TypeToken)new TypeToken<List<ImmutablePerson>>(){});
        ImmutablePerson.validatePersonListJsonCodec((JsonCodec<List<ImmutablePerson>>)jsonCodec);
    }

    @Test
    public void testImmutableMapJsonCodec() {
        JsonCodec jsonCodec = JsonCodec.mapJsonCodec(String.class, ImmutablePerson.class);
        ImmutablePerson.validatePersonMapJsonCodec((JsonCodec<Map<String, ImmutablePerson>>)jsonCodec);
    }

    @Test
    public void testImmutableMapJsonCodecFromJsonCodec() {
        JsonCodec jsonCodec = JsonCodec.mapJsonCodec(String.class, (JsonCodec)JsonCodec.jsonCodec(ImmutablePerson.class));
        ImmutablePerson.validatePersonMapJsonCodec((JsonCodec<Map<String, ImmutablePerson>>)jsonCodec);
    }

    @Test
    public void testImmutableTypeTokenMap() {
        JsonCodec jsonCodec = JsonCodec.jsonCodec((TypeToken)new TypeToken<Map<String, ImmutablePerson>>(){});
        ImmutablePerson.validatePersonMapJsonCodec((JsonCodec<Map<String, ImmutablePerson>>)jsonCodec);
    }

    @Test
    public void testToJsonWithLengthLimitSimple() {
        JsonCodec jsonCodec = JsonCodec.jsonCodec(ImmutablePerson.class);
        ImmutablePerson person = new ImmutablePerson(Strings.repeat((String)"a", (int)1000), false);
        Assertions.assertThat((Optional)jsonCodec.toJsonWithLengthLimit((Object)person, 0)).isNotPresent();
        Assertions.assertThat((Optional)jsonCodec.toJsonWithLengthLimit((Object)person, 1000)).isNotPresent();
        Assertions.assertThat((Optional)jsonCodec.toJsonWithLengthLimit((Object)person, 1035)).isNotPresent();
        Assertions.assertThat((Optional)jsonCodec.toJsonWithLengthLimit((Object)person, 1036)).isPresent();
    }

    @Test
    public void testToJsonExceedingDefaultStringLimit() {
        JsonCodec jsonCodec = JsonCodec.jsonCodec(ImmutablePerson.class);
        ImmutablePerson person = new ImmutablePerson(Strings.repeat((String)"a", (int)20000001), false);
        String json = jsonCodec.toJson((Object)person);
        Assertions.assertThat((Object)((ImmutablePerson)jsonCodec.fromJson(json))).isEqualTo((Object)person);
        byte[] bytes = jsonCodec.toJsonBytes((Object)person);
        Assertions.assertThat((Object)((ImmutablePerson)jsonCodec.fromJson(bytes))).isEqualTo((Object)person);
        Assertions.assertThat((Object)((ImmutablePerson)jsonCodec.fromJson((InputStream)new ByteArrayInputStream(bytes)))).isEqualTo((Object)person);
        Assertions.assertThat((Object)((ImmutablePerson)jsonCodec.fromJson((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8)))).isEqualTo((Object)person);
    }

    @Test
    public void testToJsonWithLengthLimitNonAscii() {
        JsonCodec jsonCodec = JsonCodec.jsonCodec(ImmutablePerson.class);
        ImmutablePerson person = new ImmutablePerson(Strings.repeat((String)"\u0158", (int)1000), false);
        Assertions.assertThat((Optional)jsonCodec.toJsonWithLengthLimit((Object)person, 0)).isNotPresent();
        Assertions.assertThat((Optional)jsonCodec.toJsonWithLengthLimit((Object)person, 1000)).isNotPresent();
        Assertions.assertThat((Optional)jsonCodec.toJsonWithLengthLimit((Object)person, 1035)).isNotPresent();
        Assertions.assertThat((Optional)jsonCodec.toJsonWithLengthLimit((Object)person, 1036)).isPresent();
    }

    @Test
    public void testToJsonWithLengthLimitComplex() {
        JsonCodec jsonCodec = JsonCodec.listJsonCodec((JsonCodec)JsonCodec.jsonCodec(ImmutablePerson.class));
        ImmutablePerson person = new ImmutablePerson(Strings.repeat((String)"a", (int)1000), false);
        List<ImmutablePerson> people = Collections.nCopies(10, person);
        Assertions.assertThat((Optional)jsonCodec.toJsonWithLengthLimit(people, 0)).isNotPresent();
        Assertions.assertThat((Optional)jsonCodec.toJsonWithLengthLimit(people, 5000)).isNotPresent();
        Assertions.assertThat((Optional)jsonCodec.toJsonWithLengthLimit(people, 10381)).isNotPresent();
        Assertions.assertThat((Optional)jsonCodec.toJsonWithLengthLimit(people, 10382)).isPresent();
    }

    @Test
    public void testTrailingContent() {
        JsonCodec codec = JsonCodec.jsonCodec(ImmutablePerson.class);
        String json = "{\"name\":\"Me\",\"rocks\":true}";
        Assertions.assertThat((String)((ImmutablePerson)codec.fromJson(json)).getName()).isEqualTo("Me");
        String jsonWithTrailingContent = json + " trailer";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> codec.fromJson(jsonWithTrailingContent)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid JSON string for [simple type, class io.airlift.json.ImmutablePerson]").hasStackTraceContaining("Unrecognized token 'trailer': was expecting (JSON String, Number, Array, Object or token 'null', 'true' or 'false')");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> codec.fromJson(jsonWithTrailingContent.getBytes(StandardCharsets.UTF_8))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid JSON bytes for [simple type, class io.airlift.json.ImmutablePerson]").hasStackTraceContaining("Unrecognized token 'trailer': was expecting (JSON String, Number, Array, Object or token 'null', 'true' or 'false')");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> codec.fromJson((InputStream)new ByteArrayInputStream(jsonWithTrailingContent.getBytes(StandardCharsets.UTF_8)))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid JSON bytes for [simple type, class io.airlift.json.ImmutablePerson]").hasStackTraceContaining("Unrecognized token 'trailer': was expecting (JSON String, Number, Array, Object or token 'null', 'true' or 'false')");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> codec.fromJson((Reader)new StringReader(jsonWithTrailingContent))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid JSON characters for [simple type, class io.airlift.json.ImmutablePerson]").hasStackTraceContaining("Unrecognized token 'trailer': was expecting (JSON String, Number, Array, Object or token 'null', 'true' or 'false')");
        String jsonWithTrailingJsonContent = json + " \"valid json value\"";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> codec.fromJson(jsonWithTrailingJsonContent)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Found characters after the expected end of input");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> codec.fromJson(jsonWithTrailingJsonContent.getBytes(StandardCharsets.UTF_8))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Found characters after the expected end of input");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> codec.fromJson((InputStream)new ByteArrayInputStream(jsonWithTrailingJsonContent.getBytes(StandardCharsets.UTF_8)))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Found characters after the expected end of input");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> codec.fromJson((Reader)new StringReader(jsonWithTrailingJsonContent))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Found characters after the expected end of input");
    }

    @Test
    public void testRecordSerialization() {
        TestJsonCodec.assertSerializationRoundTrip(JsonCodec.jsonCodec(MyRecord.class), new MyRecord("my value"), "{\n  \"foo\" : \"my value\"\n}");
        TestJsonCodec.assertSerializationRoundTrip(JsonCodec.jsonCodec(MyRecordWithBeanLikeGetter.class), new MyRecordWithBeanLikeGetter("my value"), "{\n  \"foo\" : \"my value\"\n}");
        TestJsonCodec.assertSerializationRoundTrip(JsonCodec.jsonCodec(MyRecordAdditionalGetter.class), new MyRecordAdditionalGetter("my value", true, true), "{\n  \"condition\" : true,\n  \"foo\" : \"my value\",\n  \"isCool\" : true,\n  \"additionalProperty\" : \"additional property value\"\n}");
        Assertions.assertThat((String)JsonCodec.jsonCodec(LegacyRecordAdditionalGetter.class).toJson((Object)new LegacyRecordAdditionalGetter("my value"))).isEqualTo("{\n  \"foo\" : \"not really a foo value\",\n  \"bar\" : \"there is no bar field in the record\",\n  \"safe\" : false\n}");
    }

    private static <T> void assertSerializationRoundTrip(JsonCodec<T> codec, T object, String expected) {
        Assertions.assertThat((String)codec.toJson(object)).isEqualTo(expected);
        Assertions.assertThat((Object)codec.fromJson(expected)).isEqualTo(object);
    }

    public record MyRecord(String foo) {
    }

    public record MyRecordWithBeanLikeGetter(String foo) {
        public String getFoo() {
            return this.foo();
        }
    }

    @JsonPropertyOrder(alphabetic=true)
    public record MyRecordAdditionalGetter(String foo, boolean condition, boolean isCool) {
        public String getFoo() {
            throw new UnsupportedOperationException("this method should not be called during serialization");
        }

        public String getBar() {
            return "there is no bar field in the record";
        }

        @JsonProperty
        public String getAdditionalProperty() {
            return "additional property value";
        }

        public String baz() {
            throw new UnsupportedOperationException("this method should not be called during serialization");
        }

        public boolean isCondition() {
            throw new UnsupportedOperationException("this method should not be called during serialization");
        }

        public boolean getCondition() {
            throw new UnsupportedOperationException("this method should not be called during serialization");
        }
    }

    @JsonPropertyOrder(alphabetic=true)
    @RecordAutoDetectModule.LegacyRecordIntrospection
    public record LegacyRecordAdditionalGetter(String foo) {
        public String getFoo() {
            return "not really a foo value";
        }

        public String getBar() {
            return "there is no bar field in the record";
        }

        public boolean isSafe() {
            return false;
        }
    }
}

