/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Assertions;

public class ImmutablePerson {
    private final String name;
    private final boolean rocks;
    private final String notWritable;

    public static void validatePersonJsonCodec(JsonCodec<ImmutablePerson> jsonCodec) {
        ImmutablePerson expected = new ImmutablePerson("dain", true);
        String json = jsonCodec.toJson((Object)expected);
        Assertions.assertThat((Object)((ImmutablePerson)jsonCodec.fromJson(json))).isEqualTo((Object)expected);
        byte[] bytes = jsonCodec.toJsonBytes((Object)expected);
        Assertions.assertThat((Object)((ImmutablePerson)jsonCodec.fromJson(bytes))).isEqualTo((Object)expected);
        Assertions.assertThat((Object)((ImmutablePerson)jsonCodec.fromJson((InputStream)new ByteArrayInputStream(bytes)))).isEqualTo((Object)expected);
        Assertions.assertThat((Object)((ImmutablePerson)jsonCodec.fromJson((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8)))).isEqualTo((Object)expected);
    }

    public static void validatePersonListJsonCodec(JsonCodec<List<ImmutablePerson>> jsonCodec) {
        ImmutableList expected = ImmutableList.of((Object)new ImmutablePerson("dain", true), (Object)new ImmutablePerson("martin", true), (Object)new ImmutablePerson("mark", true));
        String json = jsonCodec.toJson((Object)expected);
        Assertions.assertThat((List)((List)jsonCodec.fromJson(json))).isEqualTo((Object)expected);
        byte[] bytes = jsonCodec.toJsonBytes((Object)expected);
        Assertions.assertThat((List)((List)jsonCodec.fromJson(bytes))).isEqualTo((Object)expected);
        Assertions.assertThat((List)((List)jsonCodec.fromJson((InputStream)new ByteArrayInputStream(bytes)))).isEqualTo((Object)expected);
        Assertions.assertThat((List)((List)jsonCodec.fromJson((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8)))).isEqualTo((Object)expected);
    }

    public static void validatePersonMapJsonCodec(JsonCodec<Map<String, ImmutablePerson>> jsonCodec) {
        ImmutableMap expected = ImmutableMap.builder().put((Object)"dain", (Object)new ImmutablePerson("dain", true)).put((Object)"martin", (Object)new ImmutablePerson("martin", true)).put((Object)"mark", (Object)new ImmutablePerson("mark", true)).build();
        String json = jsonCodec.toJson((Object)expected);
        Assertions.assertThat((Map)((Map)jsonCodec.fromJson(json))).isEqualTo((Object)expected);
        byte[] bytes = jsonCodec.toJsonBytes((Object)expected);
        Assertions.assertThat((Map)((Map)jsonCodec.fromJson(bytes))).isEqualTo((Object)expected);
        Assertions.assertThat((Map)((Map)jsonCodec.fromJson((InputStream)new ByteArrayInputStream(bytes)))).isEqualTo((Object)expected);
        Assertions.assertThat((Map)((Map)jsonCodec.fromJson((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8)))).isEqualTo((Object)expected);
    }

    @JsonCreator
    public ImmutablePerson(@JsonProperty(value="name") String name, @JsonProperty(value="rocks") boolean rocks) {
        this.notWritable = null;
        this.name = name;
        this.rocks = rocks;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public boolean isRocks() {
        return this.rocks;
    }

    @JsonProperty
    public String getNotWritable() {
        return this.notWritable;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutablePerson o = (ImmutablePerson)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.rocks, o.rocks) && Objects.equals(this.notWritable, o.notWritable);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.rocks, this.notWritable);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("rocks", this.rocks).toString();
    }
}

