/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json.subtype;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.JsonModule;
import io.airlift.json.JsonSubType;
import io.airlift.json.JsonSubTypeBinder;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.json.subtype.Employee;
import io.airlift.json.subtype.Part;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJsonSubType {
    private static final Employee programmer1 = new Employee.Programmer("Joe");
    private static final Employee programmer2 = new Employee.Programmer("Rachel");
    private static final Employee programmer3 = new Employee.Programmer("Chris");
    private static final Employee manager1 = new Employee.Manager("Jane", (List<Employee>)ImmutableList.of((Object)programmer1, (Object)programmer2));
    private static final Employee manager2 = new Employee.Manager("Horace", (List<Employee>)ImmutableList.of((Object)programmer3, (Object)manager1));
    private static final Part item1 = new Part.Item("one");
    private static final Part item2 = new Part.Item("two");
    private static final Part container = new Part.Container((List<Part>)ImmutableList.of((Object)item1, (Object)item2));

    @Test
    public void testAddBinding() throws Exception {
        JsonSubType jsonSubType = JsonSubType.builder().forBase(Employee.class, "type").add(Employee.Programmer.class).add(Employee.Manager.class).build();
        Injector injector = Guice.createInjector((Module[])new Module[]{new JsonModule(), binder -> JsonSubTypeBinder.jsonSubTypeBinder((Binder)binder).bindJsonSubType(jsonSubType)});
        ObjectMapper objectMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
        TestJsonSubType.internalTest(objectMapper);
    }

    @Test
    public void testAddBindingSpecifiedNames() throws Exception {
        JsonSubType jsonSubType = JsonSubType.builder().forBase(Employee.class, "specified").add(Employee.Programmer.class, "foo").add(Employee.Manager.class, "bar").build();
        Injector injector = Guice.createInjector((Module[])new Module[]{new JsonModule(), binder -> JsonSubTypeBinder.jsonSubTypeBinder((Binder)binder).bindJsonSubType(jsonSubType)});
        ObjectMapper objectMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
        TestJsonSubType.internalTest(objectMapper);
    }

    @Test
    public void testAddPermittedSubClassBindings() throws Exception {
        JsonSubType jsonSubType = JsonSubType.builder().forBase(Employee.class, "type").addPermittedSubClasses().build();
        Injector injector = Guice.createInjector((Module[])new Module[]{new JsonModule(), binder -> JsonSubTypeBinder.jsonSubTypeBinder((Binder)binder).bindJsonSubType(jsonSubType)});
        ObjectMapper objectMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
        TestJsonSubType.internalTest(objectMapper);
    }

    @Test
    public void testAddPermittedSubClassBindingsSpecifiedNames() throws Exception {
        JsonSubType jsonSubType = JsonSubType.builder().forBase(Employee.class, "bogus").addPermittedSubClasses(clazz -> "xxx__" + clazz.getName() + "__XXX").build();
        Injector injector = Guice.createInjector((Module[])new Module[]{new JsonModule(), binder -> JsonSubTypeBinder.jsonSubTypeBinder((Binder)binder).bindJsonSubType(jsonSubType)});
        ObjectMapper objectMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
        TestJsonSubType.internalTest(objectMapper);
    }

    @Test
    public void testFailsWithoutSubClassBindings() {
        ObjectMapper objectMapper = new ObjectMapperProvider().get();
        Assertions.assertThatThrownBy(() -> TestJsonSubType.internalTest(objectMapper)).isInstanceOf(InvalidDefinitionException.class);
    }

    @Test
    public void testFailsWhenMissingBindings() {
        JsonSubType jsonSubType = JsonSubType.builder().forBase(Employee.class, "type").add(Employee.Programmer.class).build();
        Injector injector = Guice.createInjector((Module[])new Module[]{new JsonModule(), binder -> JsonSubTypeBinder.jsonSubTypeBinder((Binder)binder).bindJsonSubType(jsonSubType)});
        ObjectMapper objectMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
        Assertions.assertThatThrownBy(() -> TestJsonSubType.internalTest(objectMapper)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testBuildMultipleTypes() throws Exception {
        JsonSubType jsonSubType = JsonSubType.builder().forBase(Employee.class, "type").addPermittedSubClasses().forBase(Part.class, "category").addPermittedSubClasses().build();
        Injector injector = Guice.createInjector((Module[])new Module[]{new JsonModule(), binder -> JsonSubTypeBinder.jsonSubTypeBinder((Binder)binder).bindJsonSubType(jsonSubType)});
        ObjectMapper objectMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
        TestJsonSubType.internalTest(objectMapper);
        JsonCodecFactory codecFactory = new JsonCodecFactory(() -> objectMapper);
        JsonCodec jsonCodec = codecFactory.jsonCodec(Part.class);
        String item1Json = objectMapper.writeValueAsString((Object)item1);
        String item2Json = objectMapper.writeValueAsString((Object)item2);
        String containerJson = objectMapper.writeValueAsString((Object)container);
        for (int i = 0; i < 2; ++i) {
            Part deserializedItem1 = i == 0 ? (Part)objectMapper.readValue(item1Json, Part.class) : (Part)jsonCodec.fromJson(item1Json);
            Part deserializedItem2 = i == 0 ? (Part)objectMapper.readValue(item2Json, Part.class) : (Part)jsonCodec.fromJson(item2Json);
            Part deserializedContainer = i == 0 ? (Part)objectMapper.readValue(containerJson, Part.class) : (Part)jsonCodec.fromJson(containerJson);
            Assertions.assertThat((Object)deserializedItem1).isInstanceOf(Part.Item.class);
            Assertions.assertThat((Object)deserializedItem2).isInstanceOf(Part.Item.class);
            Assertions.assertThat((Object)deserializedContainer).isInstanceOf(Part.Container.class);
            Assertions.assertThat((Object)deserializedItem1).isEqualTo((Object)item1);
            Assertions.assertThat((Object)deserializedItem2).isEqualTo((Object)item2);
            Assertions.assertThat((Object)deserializedContainer).isEqualTo((Object)container);
        }
    }

    @Test
    public void testStandalone() throws Exception {
        JsonSubType jsonSubType = JsonSubType.builder().forBase(Employee.class, "type").add(Employee.Programmer.class).add(Employee.Manager.class).build();
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider().withJsonSubTypes((Set)ImmutableSet.of((Object)jsonSubType));
        TestJsonSubType.internalTest(objectMapperProvider.get());
    }

    @Test
    public void testExpectedJson() throws Exception {
        JsonSubType jsonSubType1 = JsonSubType.builder().forBase(Employee.class, "type").add(Employee.Programmer.class).add(Employee.Manager.class).build();
        ObjectMapper objectMapper1 = new ObjectMapperProvider().withJsonSubTypes((Set)ImmutableSet.of((Object)jsonSubType1)).get();
        String programmer1Json = objectMapper1.writeValueAsString((Object)programmer1);
        String manager1Json = objectMapper1.writeValueAsString((Object)manager1);
        JsonSubType jsonSubType2 = JsonSubType.builder().forBase(Employee.class, "category").add(Employee.Programmer.class).add(Employee.Manager.class).build();
        ObjectMapper objectMapper2 = new ObjectMapperProvider().withJsonSubTypes((Set)ImmutableSet.of((Object)jsonSubType2)).get();
        String programmer2Json = objectMapper2.writeValueAsString((Object)programmer1);
        String manager2Json = objectMapper2.writeValueAsString((Object)manager1);
        Assertions.assertThat((String)programmer1Json).isEqualTo("{\"name\":\"Joe\",\"type\":\"Programmer\"}");
        Assertions.assertThat((String)manager1Json).isEqualTo("{\"name\":\"Jane\",\"reports\":[{\"name\":\"Joe\",\"type\":\"Programmer\"},{\"name\":\"Rachel\",\"type\":\"Programmer\"}],\"type\":\"Manager\"}");
        Assertions.assertThat((String)programmer2Json).isEqualTo("{\"name\":\"Joe\",\"category\":\"Programmer\"}");
        Assertions.assertThat((String)manager2Json).isEqualTo("{\"name\":\"Jane\",\"reports\":[{\"name\":\"Joe\",\"category\":\"Programmer\"},{\"name\":\"Rachel\",\"category\":\"Programmer\"}],\"category\":\"Manager\"}");
    }

    private static void internalTest(ObjectMapper objectMapper) throws JsonProcessingException {
        JsonCodecFactory codecFactory = new JsonCodecFactory(() -> objectMapper);
        JsonCodec jsonCodec = codecFactory.jsonCodec(Employee.class);
        String programmer1Json = objectMapper.writeValueAsString((Object)programmer1);
        String programmer2Json = objectMapper.writeValueAsString((Object)programmer2);
        String programmer3Json = objectMapper.writeValueAsString((Object)programmer3);
        String manager1Json = objectMapper.writeValueAsString((Object)manager1);
        String manager2Json = objectMapper.writeValueAsString((Object)manager2);
        for (int i = 0; i < 2; ++i) {
            Employee deserializedProgrammer1 = i == 0 ? (Employee)objectMapper.readValue(programmer1Json, Employee.class) : (Employee)jsonCodec.fromJson(programmer1Json);
            Employee deserializedProgrammer2 = i == 0 ? (Employee)objectMapper.readValue(programmer2Json, Employee.class) : (Employee)jsonCodec.fromJson(programmer2Json);
            Employee deserializedProgrammer3 = i == 0 ? (Employee)objectMapper.readValue(programmer3Json, Employee.class) : (Employee)jsonCodec.fromJson(programmer3Json);
            Employee deserializedManager1 = i == 0 ? (Employee)objectMapper.readValue(manager1Json, Employee.class) : (Employee)jsonCodec.fromJson(manager1Json);
            Employee deserializedManager2 = i == 0 ? (Employee)objectMapper.readValue(manager2Json, Employee.class) : (Employee)jsonCodec.fromJson(manager2Json);
            Assertions.assertThat((Object)deserializedProgrammer1).isInstanceOf(Employee.Programmer.class);
            Assertions.assertThat((Object)deserializedProgrammer2).isInstanceOf(Employee.Programmer.class);
            Assertions.assertThat((Object)deserializedProgrammer3).isInstanceOf(Employee.Programmer.class);
            Assertions.assertThat((Object)deserializedManager1).isInstanceOf(Employee.Manager.class);
            Assertions.assertThat((Object)deserializedManager2).isInstanceOf(Employee.Manager.class);
            Assertions.assertThat((Object)deserializedProgrammer1).isEqualTo((Object)programmer1);
            Assertions.assertThat((Object)deserializedProgrammer2).isEqualTo((Object)programmer2);
            Assertions.assertThat((Object)deserializedProgrammer3).isEqualTo((Object)programmer3);
            Assertions.assertThat((Object)deserializedManager1).isEqualTo((Object)manager1);
            Assertions.assertThat((Object)deserializedManager2).isEqualTo((Object)manager2);
        }
    }
}

