/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJsonCodecFactory {
    private JsonCodecFactory jsonCodecFactory = new JsonCodecFactory();

    @Test
    public void testJsonCodec() {
        JsonCodec jsonCodec = this.jsonCodecFactory.jsonCodec(Person.class);
        Person expected = new Person().setName("dain").setRocks(true);
        String json = jsonCodec.toJson((Object)expected);
        Person actual = (Person)jsonCodec.fromJson(json);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testListJsonCodec() {
        JsonCodec jsonCodec = this.jsonCodecFactory.listJsonCodec(Person.class);
        this.validateListCodec((JsonCodec<List<Person>>)jsonCodec);
    }

    @Test
    public void testListJsonCodecFromJsonCodec() {
        JsonCodec jsonCodec = this.jsonCodecFactory.listJsonCodec(this.jsonCodecFactory.jsonCodec(Person.class));
        this.validateListCodec((JsonCodec<List<Person>>)jsonCodec);
    }

    @Test
    public void testTypeLiteralList() {
        JsonCodec jsonCodec = this.jsonCodecFactory.jsonCodec((TypeToken)new TypeToken<List<Person>>(){});
        this.validateListCodec((JsonCodec<List<Person>>)jsonCodec);
    }

    private void validateListCodec(JsonCodec<List<Person>> jsonCodec) {
        ImmutableList expected = ImmutableList.of((Object)new Person().setName("dain").setRocks(true), (Object)new Person().setName("martin").setRocks(true), (Object)new Person().setName("mark").setRocks(true));
        String json = jsonCodec.toJson((Object)expected);
        List actual = (List)jsonCodec.fromJson(json);
        Assertions.assertThat((List)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testMapJsonCodec() {
        JsonCodec jsonCodec = this.jsonCodecFactory.mapJsonCodec(String.class, Person.class);
        this.validateMapCodec((JsonCodec<Map<String, Person>>)jsonCodec);
    }

    @Test
    public void testMapJsonCodecFromJsonCodec() {
        JsonCodec jsonCodec = this.jsonCodecFactory.mapJsonCodec(String.class, this.jsonCodecFactory.jsonCodec(Person.class));
        this.validateMapCodec((JsonCodec<Map<String, Person>>)jsonCodec);
    }

    @Test
    public void testTypeLiteralMap() {
        JsonCodec jsonCodec = this.jsonCodecFactory.jsonCodec((TypeToken)new TypeToken<Map<String, Person>>(){});
        this.validateMapCodec((JsonCodec<Map<String, Person>>)jsonCodec);
    }

    private void validateMapCodec(JsonCodec<Map<String, Person>> jsonCodec) {
        ImmutableMap expected = ImmutableMap.builder().put((Object)"dain", (Object)new Person().setName("dain").setRocks(true)).put((Object)"martin", (Object)new Person().setName("martin").setRocks(true)).put((Object)"mark", (Object)new Person().setName("mark").setRocks(true)).build();
        String json = jsonCodec.toJson((Object)expected);
        Map actual = (Map)jsonCodec.fromJson(json);
        Assertions.assertThat((Map)actual).isEqualTo((Object)expected);
    }

    public static class Person {
        private String name;
        private boolean rocks;

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public Person setName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty
        public boolean isRocks() {
            return this.rocks;
        }

        @JsonProperty
        public Person setRocks(boolean rocks) {
            this.rocks = rocks;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            if (this.rocks != person.rocks) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(person.name) : person.name != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.rocks ? 1 : 0);
            return result;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("rocks", this.rocks).toString();
        }
    }
}

