/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.Car;
import io.airlift.json.JsonCodec;
import io.airlift.json.Truck;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Car.class, name="car"), @JsonSubTypes.Type(value=Truck.class, name="truck")})
public interface Vehicle {
    public static void validateVehicleJsonCodec(JsonCodec<Vehicle> jsonCodec) {
        Vehicle expected = new Car("bmw");
        String json = jsonCodec.toJson((Object)expected);
        Assertions.assertThat((Object)((Vehicle)jsonCodec.fromJson(json))).isEqualTo((Object)expected);
        Assertions.assertThat((boolean)json.contains("\"@type\" : \"car\"")).isTrue();
        byte[] bytes = jsonCodec.toJsonBytes((Object)expected);
        Assertions.assertThat((Object)((Vehicle)jsonCodec.fromJson(bytes))).isEqualTo((Object)expected);
        expected = new Truck("volvo");
        json = jsonCodec.toJson((Object)expected);
        Assertions.assertThat((Object)((Vehicle)jsonCodec.fromJson(json))).isEqualTo((Object)expected);
        Assertions.assertThat((boolean)json.contains("\"@type\" : \"truck\"")).isTrue();
        bytes = jsonCodec.toJsonBytes((Object)expected);
        Assertions.assertThat((Object)((Vehicle)jsonCodec.fromJson(bytes))).isEqualTo((Object)expected);
    }

    public static void validateVehicleListJsonCodec(JsonCodec<List<Vehicle>> jsonCodec) {
        ImmutableList expected = ImmutableList.of((Object)new Car("bmw"), (Object)new Truck("volvo"));
        String json = jsonCodec.toJson((Object)expected);
        Assertions.assertThat((List)((List)jsonCodec.fromJson(json))).isEqualTo((Object)expected);
        byte[] bytes = jsonCodec.toJsonBytes((Object)expected);
        Assertions.assertThat((List)((List)jsonCodec.fromJson(bytes))).isEqualTo((Object)expected);
    }

    public static void validateVehicleMapJsonCodec(JsonCodec<Map<String, Vehicle>> jsonCodec) {
        ImmutableMap expected = ImmutableMap.builder().put((Object)"bmw", (Object)new Car("bmw")).put((Object)"volvo", (Object)new Truck("volvo")).build();
        String json = jsonCodec.toJson((Object)expected);
        Assertions.assertThat((Map)((Map)jsonCodec.fromJson(json))).isEqualTo((Object)expected);
        byte[] bytes = jsonCodec.toJsonBytes((Object)expected);
        Assertions.assertThat((Map)((Map)jsonCodec.fromJson(bytes))).isEqualTo((Object)expected);
    }
}

