/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecBinder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJsonCodecBinder {
    @Test
    public void ignoresRepeatedBinding() {
        Injector injector = Guice.createInjector((Module[])new Module[]{binder -> {
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(Integer.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(Integer.class);
            binder.bind(Dummy.class).in(Scopes.SINGLETON);
        }});
        Assertions.assertThat(((Dummy)injector.getInstance(Dummy.class)).getCodec()).isNotNull();
    }

    private static class Dummy {
        private final JsonCodec<Integer> codec;

        @Inject
        public Dummy(JsonCodec<Integer> codec) {
            this.codec = codec;
        }

        public JsonCodec<Integer> getCodec() {
            return this.codec;
        }
    }
}

