/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import io.airlift.json.ImmutablePerson;
import io.airlift.json.JsonCodec;
import io.airlift.json.Person;
import io.airlift.json.Vehicle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJsonCodec {
    @Test
    public void testJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.jsonCodec(Person.class);
        Person.validatePersonJsonCodec((JsonCodec<Person>)jsonCodec);
        JsonCodec vehicleJsonCodec = JsonCodec.jsonCodec(Vehicle.class);
        Vehicle.validateVehicleJsonCodec((JsonCodec<Vehicle>)vehicleJsonCodec);
    }

    @Test
    public void testListJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.listJsonCodec(Person.class);
        Person.validatePersonListJsonCodec((JsonCodec<List<Person>>)jsonCodec);
        JsonCodec vehicleJsonCodec = JsonCodec.listJsonCodec(Vehicle.class);
        Vehicle.validateVehicleListJsonCodec((JsonCodec<List<Vehicle>>)vehicleJsonCodec);
    }

    @Test
    public void testListJsonCodecFromJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.listJsonCodec((JsonCodec)JsonCodec.jsonCodec(Person.class));
        Person.validatePersonListJsonCodec((JsonCodec<List<Person>>)jsonCodec);
        JsonCodec vehicleJsonCodec = JsonCodec.listJsonCodec((JsonCodec)JsonCodec.jsonCodec(Vehicle.class));
        Vehicle.validateVehicleListJsonCodec((JsonCodec<List<Vehicle>>)vehicleJsonCodec);
    }

    @Test
    public void testTypeTokenList() throws Exception {
        JsonCodec jsonCodec = JsonCodec.jsonCodec((TypeToken)new TypeToken<List<Person>>(){});
        Person.validatePersonListJsonCodec((JsonCodec<List<Person>>)jsonCodec);
        JsonCodec vehicleJsonCodec = JsonCodec.jsonCodec((TypeToken)new TypeToken<List<Vehicle>>(){});
        Vehicle.validateVehicleListJsonCodec((JsonCodec<List<Vehicle>>)vehicleJsonCodec);
    }

    @Test
    public void testListNullValues() {
        JsonCodec jsonCodec = JsonCodec.listJsonCodec(String.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add(null);
        list.add("abc");
        Assert.assertEquals((Collection)((Collection)jsonCodec.fromJson(jsonCodec.toJson(list))), list);
    }

    @Test
    public void testMapJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.mapJsonCodec(String.class, Person.class);
        Person.validatePersonMapJsonCodec((JsonCodec<Map<String, Person>>)jsonCodec);
        JsonCodec vehicleJsonCodec = JsonCodec.mapJsonCodec(String.class, Vehicle.class);
        Vehicle.validateVehicleMapJsonCodec((JsonCodec<Map<String, Vehicle>>)vehicleJsonCodec);
    }

    @Test
    public void testMapJsonCodecFromJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.mapJsonCodec(String.class, (JsonCodec)JsonCodec.jsonCodec(Person.class));
        Person.validatePersonMapJsonCodec((JsonCodec<Map<String, Person>>)jsonCodec);
        JsonCodec vehicleJsonCodec = JsonCodec.mapJsonCodec(String.class, (JsonCodec)JsonCodec.jsonCodec(Vehicle.class));
        Vehicle.validateVehicleMapJsonCodec((JsonCodec<Map<String, Vehicle>>)vehicleJsonCodec);
    }

    @Test
    public void testTypeLiteralMap() throws Exception {
        JsonCodec jsonCodec = JsonCodec.jsonCodec((TypeToken)new TypeToken<Map<String, Person>>(){});
        Person.validatePersonMapJsonCodec((JsonCodec<Map<String, Person>>)jsonCodec);
        JsonCodec vehicleJsonCodec = JsonCodec.jsonCodec((TypeToken)new TypeToken<Map<String, Vehicle>>(){});
        Vehicle.validateVehicleMapJsonCodec((JsonCodec<Map<String, Vehicle>>)vehicleJsonCodec);
    }

    @Test
    public void testMapNullValues() {
        JsonCodec jsonCodec = JsonCodec.mapJsonCodec(String.class, String.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("x", null);
        map.put("y", "abc");
        Assert.assertEquals((Map)((Map)jsonCodec.fromJson(jsonCodec.toJson(map))), map);
    }

    @Test
    public void testImmutableJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.jsonCodec(ImmutablePerson.class);
        ImmutablePerson.validatePersonJsonCodec((JsonCodec<ImmutablePerson>)jsonCodec);
    }

    @Test
    public void testAsymmetricJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.jsonCodec(ImmutablePerson.class);
        ImmutablePerson immutablePerson = (ImmutablePerson)jsonCodec.fromJson("{ \"notWritable\": \"foo\" }");
        Assert.assertNull((Object)immutablePerson.getNotWritable());
    }

    @Test
    public void testImmutableListJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.listJsonCodec(ImmutablePerson.class);
        ImmutablePerson.validatePersonListJsonCodec((JsonCodec<List<ImmutablePerson>>)jsonCodec);
    }

    @Test
    public void testImmutableListJsonCodecFromJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.listJsonCodec((JsonCodec)JsonCodec.jsonCodec(ImmutablePerson.class));
        ImmutablePerson.validatePersonListJsonCodec((JsonCodec<List<ImmutablePerson>>)jsonCodec);
    }

    @Test
    public void testImmutableTypeTokenList() throws Exception {
        JsonCodec jsonCodec = JsonCodec.jsonCodec((TypeToken)new TypeToken<List<ImmutablePerson>>(){});
        ImmutablePerson.validatePersonListJsonCodec((JsonCodec<List<ImmutablePerson>>)jsonCodec);
    }

    @Test
    public void testImmutableMapJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.mapJsonCodec(String.class, ImmutablePerson.class);
        ImmutablePerson.validatePersonMapJsonCodec((JsonCodec<Map<String, ImmutablePerson>>)jsonCodec);
    }

    @Test
    public void testImmutableMapJsonCodecFromJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.mapJsonCodec(String.class, (JsonCodec)JsonCodec.jsonCodec(ImmutablePerson.class));
        ImmutablePerson.validatePersonMapJsonCodec((JsonCodec<Map<String, ImmutablePerson>>)jsonCodec);
    }

    @Test
    public void testImmutableTypeTokenMap() throws Exception {
        JsonCodec jsonCodec = JsonCodec.jsonCodec((TypeToken)new TypeToken<Map<String, ImmutablePerson>>(){});
        ImmutablePerson.validatePersonMapJsonCodec((JsonCodec<Map<String, ImmutablePerson>>)jsonCodec);
    }

    @Test
    public void testToJsonWithLengthLimitSimple() {
        JsonCodec jsonCodec = JsonCodec.jsonCodec(ImmutablePerson.class);
        ImmutablePerson person = new ImmutablePerson(Strings.repeat((String)"a", (int)1000), false);
        Assert.assertFalse((boolean)jsonCodec.toJsonWithLengthLimit((Object)person, 0).isPresent());
        Assert.assertFalse((boolean)jsonCodec.toJsonWithLengthLimit((Object)person, 1000).isPresent());
        Assert.assertFalse((boolean)jsonCodec.toJsonWithLengthLimit((Object)person, 1035).isPresent());
        Assert.assertTrue((boolean)jsonCodec.toJsonWithLengthLimit((Object)person, 1036).isPresent());
    }

    @Test
    public void testToJsonExceedingDefaultStringLimit() {
        JsonCodec jsonCodec = JsonCodec.jsonCodec(ImmutablePerson.class);
        ImmutablePerson person = new ImmutablePerson(Strings.repeat((String)"a", (int)5000001), false);
        String json = jsonCodec.toJson((Object)person);
        Assert.assertEquals((Object)jsonCodec.fromJson(json), (Object)person);
        byte[] bytes = jsonCodec.toJsonBytes((Object)person);
        Assert.assertEquals((Object)jsonCodec.fromJson(bytes), (Object)person);
    }

    @Test
    public void testToJsonWithLengthLimitNonAscii() {
        JsonCodec jsonCodec = JsonCodec.jsonCodec(ImmutablePerson.class);
        ImmutablePerson person = new ImmutablePerson(Strings.repeat((String)"\u0158", (int)1000), false);
        Assert.assertFalse((boolean)jsonCodec.toJsonWithLengthLimit((Object)person, 0).isPresent());
        Assert.assertFalse((boolean)jsonCodec.toJsonWithLengthLimit((Object)person, 1000).isPresent());
        Assert.assertFalse((boolean)jsonCodec.toJsonWithLengthLimit((Object)person, 1035).isPresent());
        Assert.assertTrue((boolean)jsonCodec.toJsonWithLengthLimit((Object)person, 1036).isPresent());
    }

    @Test
    public void testToJsonWithLengthLimitComplex() {
        JsonCodec jsonCodec = JsonCodec.listJsonCodec((JsonCodec)JsonCodec.jsonCodec(ImmutablePerson.class));
        ImmutablePerson person = new ImmutablePerson(Strings.repeat((String)"a", (int)1000), false);
        List<ImmutablePerson> people = Collections.nCopies(10, person);
        Assert.assertFalse((boolean)jsonCodec.toJsonWithLengthLimit(people, 0).isPresent());
        Assert.assertFalse((boolean)jsonCodec.toJsonWithLengthLimit(people, 5000).isPresent());
        Assert.assertFalse((boolean)jsonCodec.toJsonWithLengthLimit(people, 10381).isPresent());
        Assert.assertTrue((boolean)jsonCodec.toJsonWithLengthLimit(people, 10382).isPresent());
    }
}

