/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.json.JsonBinder;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.JsonModule;
import io.airlift.json.Person;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJsonModule {
    public static final Car CAR = new Car().setMake("BMW").setModel("M3").setYear(2011).setPurchased(new DateTime().withZone(DateTimeZone.UTC)).setNotes("sweet!").setNameList(TestJsonModule.superDuper("d*a*i*n"));
    private ObjectMapper objectMapper;

    @BeforeClass
    public void setUp() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new JsonModule(), binder -> {
            JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(SuperDuperNameList.class).toInstance((Object)ToStringSerializer.instance);
            JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(SuperDuperNameList.class).to(SuperDuperNameListDeserializer.class);
        }});
        this.objectMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
    }

    @Test
    public void testJsonCodecFactoryBinding() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new JsonModule()});
        JsonCodecFactory codecFactory = (JsonCodecFactory)injector.getInstance(JsonCodecFactory.class);
        Person.validatePersonJsonCodec((JsonCodec<Person>)codecFactory.jsonCodec(Person.class));
        Person.validatePersonListJsonCodec((JsonCodec<List<Person>>)codecFactory.listJsonCodec(Person.class));
        Person.validatePersonMapJsonCodec((JsonCodec<Map<String, Person>>)codecFactory.mapJsonCodec(String.class, Person.class));
    }

    @Test
    public void testSetup() throws Exception {
        Assert.assertEquals((Object)CAR, (Object)CAR);
        String json = this.objectMapper.writeValueAsString((Object)CAR);
        Car actual = (Car)this.objectMapper.readValue(json, Car.class);
        Assert.assertEquals((Object)actual, (Object)CAR);
    }

    @Test
    public void testFieldDetection() throws Exception {
        Map<String, Object> actual = this.createCarMap();
        Assert.assertEquals(actual.keySet(), (Set)ImmutableSet.of((Object)"make", (Object)"model", (Object)"year", (Object)"purchased", (Object)"nameList"));
    }

    @Test
    public void testDateTimeRendered() throws Exception {
        Map<String, Object> actual = this.createCarMap();
        Assert.assertEquals((Object)actual.get("purchased"), (Object)ISODateTimeFormat.dateTime().print((ReadableInstant)CAR.getPurchased()));
    }

    @Test
    public void testGuavaRoundTrip() throws Exception {
        ImmutableList list = ImmutableList.of((Object)3, (Object)5, (Object)8);
        String json = this.objectMapper.writeValueAsString((Object)list);
        ImmutableList actual = (ImmutableList)this.objectMapper.readValue(json, (TypeReference)new TypeReference<ImmutableList<Integer>>(){});
        Assert.assertEquals((Collection)actual, (Collection)list);
    }

    @Test
    public void testIgnoreUnknownFields() throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>(this.createCarMap());
        data.put("unknown", "bogus");
        Assert.assertEquals((Object)this.objectMapper.readValue(this.objectMapper.writeValueAsString(data), Car.class), (Object)CAR);
    }

    @Test
    public void testPropertyNamesFromParameterNames() throws Exception {
        NoJsonPropertiesInJsonCreator value = new NoJsonPropertiesInJsonCreator("first value", "second value");
        NoJsonPropertiesInJsonCreator mapped = (NoJsonPropertiesInJsonCreator)this.objectMapper.readValue(this.objectMapper.writeValueAsString((Object)value), NoJsonPropertiesInJsonCreator.class);
        Assert.assertEquals((String)mapped.getFirst(), (String)"first value");
        Assert.assertEquals((String)mapped.getSecond(), (String)"second value");
    }

    @Test
    public void testJsonValueAndStaticFactoryMethod() throws Exception {
        JsonValueAndStaticFactoryMethod value = JsonValueAndStaticFactoryMethod.valueOf("some value");
        JsonValueAndStaticFactoryMethod mapped = (JsonValueAndStaticFactoryMethod)this.objectMapper.readValue(this.objectMapper.writeValueAsString((Object)value), JsonValueAndStaticFactoryMethod.class);
        Assert.assertEquals((String)mapped.getValue(), (String)"some value");
    }

    private Map<String, Object> createCarMap() throws IOException {
        return (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString((Object)CAR), (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static SuperDuperNameList superDuper(String superDuperNameList) {
        return new SuperDuperNameList(superDuperNameList, null);
    }

    public static final class SuperDuperNameListDeserializer
    extends StdScalarDeserializer<SuperDuperNameList> {
        public SuperDuperNameListDeserializer() {
            super(SuperDuperNameList.class);
        }

        public SuperDuperNameList deserialize(JsonParser jp, DeserializationContext context) throws IOException {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.VALUE_STRING) {
                return new SuperDuperNameList(jp.getText(), null);
            }
            context.handleUnexpectedToken(this.handledType(), jp);
            throw JsonMappingException.from((JsonParser)jp, null);
        }
    }

    public static class SuperDuperNameList {
        private List<String> name;

        private SuperDuperNameList(String superDuperNameList) {
            this(superDuperNameList, null);
        }

        private SuperDuperNameList(String superDuperNameList, Object stopJacksonFromUsingStringConstructor) {
            this.name = ImmutableList.copyOf((Iterable)Splitter.on((char)'*').split((CharSequence)superDuperNameList));
        }

        public List<String> getName() {
            return this.name;
        }

        public String toString() {
            return Joiner.on((String)"*").join(this.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SuperDuperNameList)) {
                return false;
            }
            SuperDuperNameList that = (SuperDuperNameList)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static class JsonValueAndStaticFactoryMethod {
        private final String value;

        @JsonCreator
        public static JsonValueAndStaticFactoryMethod valueOf(String value) {
            return new JsonValueAndStaticFactoryMethod(value);
        }

        private JsonValueAndStaticFactoryMethod(String value) {
            this.value = Objects.requireNonNull(value, "value is null");
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }

    public static class NoJsonPropertiesInJsonCreator {
        private final String first;
        private final String second;

        @JsonCreator
        public NoJsonPropertiesInJsonCreator(String first, String second) {
            this.first = first;
            this.second = second;
        }

        @JsonProperty
        public String getFirst() {
            return this.first;
        }

        @JsonProperty
        public String getSecond() {
            return this.second;
        }
    }

    public static class Car {
        public String make;
        public String model;
        public int year;
        public DateTime purchased;
        public String color;
        public String notes;
        public SuperDuperNameList nameList;

        @JsonProperty
        public String getMake() {
            return this.make;
        }

        @JsonProperty
        public Car setMake(String make) {
            this.make = make;
            return this;
        }

        @JsonProperty
        public String getModel() {
            return this.model;
        }

        @JsonProperty
        public Car setModel(String model) {
            this.model = model;
            return this;
        }

        @JsonProperty
        public int getYear() {
            return this.year;
        }

        @JsonProperty
        public Car setYear(int year) {
            this.year = year;
            return this;
        }

        @JsonProperty
        public DateTime getPurchased() {
            return this.purchased;
        }

        @JsonProperty
        public Car setPurchased(DateTime purchased) {
            this.purchased = purchased;
            return this;
        }

        @JsonProperty
        public String getColor() {
            return this.color;
        }

        @JsonProperty
        public Car setColor(String color) {
            this.color = color;
            return this;
        }

        @JsonProperty
        public SuperDuperNameList getNameList() {
            return this.nameList;
        }

        @JsonProperty
        public Car setNameList(SuperDuperNameList nameList) {
            this.nameList = nameList;
            return this;
        }

        public String getNotes() {
            return this.notes;
        }

        public Car setNotes(String notes) {
            this.notes = notes;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Car)) {
                return false;
            }
            Car car = (Car)o;
            if (this.year != car.year) {
                return false;
            }
            if (this.color != null ? !this.color.equals(car.color) : car.color != null) {
                return false;
            }
            if (this.make != null ? !this.make.equals(car.make) : car.make != null) {
                return false;
            }
            if (this.model != null ? !this.model.equals(car.model) : car.model != null) {
                return false;
            }
            if (this.nameList != null ? !this.nameList.equals(car.nameList) : car.nameList != null) {
                return false;
            }
            return !(this.purchased != null ? !this.purchased.equals((Object)car.purchased) : car.purchased != null);
        }

        public int hashCode() {
            int result = this.make != null ? this.make.hashCode() : 0;
            result = 31 * result + (this.model != null ? this.model.hashCode() : 0);
            result = 31 * result + this.year;
            result = 31 * result + (this.purchased != null ? this.purchased.hashCode() : 0);
            result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
            result = 31 * result + (this.nameList != null ? this.nameList.hashCode() : 0);
            return result;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("make", (Object)this.make).add("model", (Object)this.model).add("year", this.year).add("purchased", (Object)this.purchased).add("color", (Object)this.color).add("notes", (Object)this.notes).add("nameList", (Object)this.nameList).toString();
        }
    }
}

