/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.Descriptor;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

@JsonPropertyOrder(value={"objectName", "className", "description", "descriptor", "attributes", "operations"})
public class MBeanRepresentation {
    private final ObjectName objectName;
    private final String className;
    private final String description;
    private final Map<String, Object> descriptor;
    private final List<AttributeRepresentation> attributes;
    private final List<OperationRepresentation> operations;

    public MBeanRepresentation(MBeanServer mbeanServer, ObjectName objectName, ObjectMapper objectMapper) throws JMException {
        this.objectName = objectName;
        MBeanInfo mbeanInfo = mbeanServer.getMBeanInfo(objectName);
        this.className = mbeanInfo.getClassName();
        this.description = mbeanInfo.getDescription();
        this.descriptor = MBeanRepresentation.toMap(mbeanInfo.getDescriptor());
        LinkedHashMap<String, MBeanAttributeInfo> attributeInfos = new LinkedHashMap<String, MBeanAttributeInfo>();
        for (MBeanAttributeInfo attributeInfo : mbeanInfo.getAttributes()) {
            attributeInfos.put(attributeInfo.getName(), attributeInfo);
        }
        String[] attributeNames = attributeInfos.keySet().toArray(new String[0]);
        ImmutableList.Builder attributes = ImmutableList.builder();
        for (Attribute attribute : mbeanServer.getAttributes(objectName, attributeNames).asList()) {
            String attributeName = attribute.getName();
            MBeanAttributeInfo attributeInfo = (MBeanAttributeInfo)attributeInfos.remove(attributeName);
            if (attributeInfo == null) continue;
            Object attributeValue = attribute.getValue();
            AttributeRepresentation attributeRepresentation = new AttributeRepresentation(attributeInfo, attributeValue, objectMapper);
            attributes.add((Object)attributeRepresentation);
        }
        this.attributes = attributes.build();
        ImmutableList.Builder operations = ImmutableList.builder();
        for (MBeanOperationInfo operationInfo : mbeanInfo.getOperations()) {
            operations.add((Object)new OperationRepresentation(operationInfo));
        }
        this.operations = operations.build();
    }

    @JsonProperty
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @JsonProperty
    public String getClassName() {
        return this.className;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public Map<String, Object> getDescriptor() {
        return this.descriptor;
    }

    @JsonProperty
    public List<AttributeRepresentation> getAttributes() {
        return this.attributes;
    }

    @JsonProperty
    public List<OperationRepresentation> getOperations() {
        return this.operations;
    }

    private static Map<String, Object> toMap(Descriptor descriptor) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String fieldName : descriptor.getFieldNames()) {
            Map<String, Object> fieldValue = descriptor.getFieldValue(fieldName);
            if (fieldValue == null) continue;
            if (fieldValue instanceof Descriptor) {
                fieldValue = MBeanRepresentation.toMap((Descriptor)((Object)fieldValue));
            }
            builder.put((Object)fieldName, fieldValue);
        }
        ImmutableMap map = builder.build();
        if (!map.isEmpty()) {
            return map;
        }
        return null;
    }

    @JsonPropertyOrder(value={"name", "type", "description", "readable", "writable", "descriptor", "value"})
    public static class AttributeRepresentation {
        private final String name;
        private final String type;
        private final String description;
        private final boolean readable;
        private final boolean writable;
        private final Map<String, Object> descriptor;
        private final Object value;

        private AttributeRepresentation(MBeanAttributeInfo attributeInfo, Object value, ObjectMapper objectMapper) {
            if (AttributeRepresentation.canSerialize(value, objectMapper)) {
                this.value = value;
                this.readable = attributeInfo.isReadable();
                this.writable = attributeInfo.isWritable();
            } else {
                this.value = null;
                this.readable = false;
                this.writable = false;
            }
            this.name = attributeInfo.getName();
            this.type = attributeInfo.getType();
            this.description = attributeInfo.getDescription();
            this.descriptor = MBeanRepresentation.toMap(attributeInfo.getDescriptor());
        }

        private static boolean canSerialize(Object value, ObjectMapper objectMapper) {
            if (value == null) {
                return true;
            }
            try {
                objectMapper.writeValue(OutputStream.nullOutputStream(), value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public String getType() {
            return this.type;
        }

        @JsonProperty
        public String getDescription() {
            return this.description;
        }

        @JsonProperty
        public boolean isReadable() {
            return this.readable;
        }

        @JsonProperty
        public boolean isWritable() {
            return this.writable;
        }

        @JsonProperty
        public Map<String, Object> getDescriptor() {
            return this.descriptor;
        }

        @JsonProperty
        public Object getValue() {
            return this.value;
        }
    }

    @JsonPropertyOrder(value={"name", "impact", "returnType", "descriptor", "parameters"})
    public static class OperationRepresentation {
        private final String name;
        private final int impact;
        private final String returnType;
        private final List<ParameterRepresentation> parameters;
        private final Map<String, Object> descriptor;

        private OperationRepresentation(MBeanOperationInfo operationInfo) {
            this.name = operationInfo.getName();
            this.impact = operationInfo.getImpact();
            this.returnType = operationInfo.getReturnType();
            ImmutableList.Builder parameters = ImmutableList.builder();
            for (MBeanParameterInfo parameterInfo : operationInfo.getSignature()) {
                parameters.add((Object)new ParameterRepresentation(parameterInfo));
            }
            this.parameters = parameters.build();
            this.descriptor = MBeanRepresentation.toMap(operationInfo.getDescriptor());
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public int getImpact() {
            return this.impact;
        }

        @JsonProperty
        public String getReturnType() {
            return this.returnType;
        }

        @JsonProperty
        public List<ParameterRepresentation> getParameters() {
            return this.parameters;
        }

        @JsonProperty
        public Map<String, Object> getDescriptor() {
            return this.descriptor;
        }
    }

    @JsonPropertyOrder(value={"name", "type", "description", "descriptor"})
    public static class ParameterRepresentation {
        private final String name;
        private final String description;
        private final String type;
        private final Map<String, Object> descriptor;

        public ParameterRepresentation(MBeanParameterInfo parameterInfo) {
            this.name = parameterInfo.getName();
            this.description = parameterInfo.getDescription();
            this.type = parameterInfo.getType();
            this.descriptor = MBeanRepresentation.toMap(parameterInfo.getDescriptor());
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public String getDescription() {
            return this.description;
        }

        @JsonProperty
        public String getType() {
            return this.type;
        }

        @JsonProperty
        public Map<String, Object> getDescriptor() {
            return this.descriptor;
        }
    }
}

