/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StringResponseHandler;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.http.server.testing.TestingHttpServerModule;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.JmxHttpModule;
import io.airlift.json.JsonModule;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.node.testing.TestingNodeModule;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestMBeanResource {
    private final MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private LifeCycleManager lifeCycleManager;
    private TestingHttpServer server;
    private HttpClient client;

    @BeforeAll
    public void setup() {
        Bootstrap app = new Bootstrap(new Module[]{new TestingNodeModule(), new TestingHttpServerModule(), new JsonModule(), new JaxrsModule(), new JmxHttpModule(), binder -> binder.bind(MBeanServer.class).toInstance((Object)this.mbeanServer)});
        Injector injector = app.quiet().initialize();
        this.lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        this.server = (TestingHttpServer)injector.getInstance(TestingHttpServer.class);
        this.client = new JettyHttpClient();
    }

    @AfterAll
    public void teardown() {
        try (HttpClient ignored = this.client;){
            if (this.lifeCycleManager != null) {
                this.lifeCycleManager.stop();
            }
        }
    }

    @Test
    public void testGetHtmlPage() {
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.client.execute(Request.Builder.prepareGet().setUri(this.uriFor("/v1/jmx")).build(), (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        Assertions.assertThat((int)response.getStatusCode()).isEqualTo(200);
        TestMBeanResource.assertContentType(response, MediaType.HTML_UTF_8);
        io.airlift.testing.Assertions.assertContains((String)response.getBody(), (String)"<html>");
    }

    @Test
    public void testGetMBeans() throws Exception {
        this.assertMBeansResponse(this.jsonRequest(this.uriFor("/v1/jmx/mbean")));
    }

    @Test
    public void testGetMBeansJsonp() throws Exception {
        this.assertMBeansResponse(this.jsonpRequest(this.uriFor("/v1/jmx/mbean")));
    }

    private void assertMBeansResponse(JsonNode mbeans) {
        ArrayList<String> names = new ArrayList<String>();
        for (JsonNode mbean : mbeans) {
            JsonNode name = mbean.get("objectName");
            Assertions.assertThat((boolean)name.isTextual()).isTrue();
            names.add(name.asText());
        }
        Assertions.assertThat(names).contains((Object[])new String[]{"java.lang:type=Memory"});
        Assertions.assertThat(names).contains((Object[])new String[]{"java.lang:type=Runtime"});
        io.airlift.testing.Assertions.assertEqualsIgnoreOrder(names, this.getMBeanNames());
    }

    @Test
    public void testGetMBean() throws Exception {
        for (String mbeanName : this.getMBeanNames()) {
            URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.uriFor("/v1/jmx/mbean")).appendPath(mbeanName).build();
            JsonNode mbean = this.jsonRequest(uri);
            JsonNode name = mbean.get("objectName");
            Assertions.assertThat((boolean)name.isTextual()).isTrue();
            Assertions.assertThat((String)name.asText()).isEqualTo(mbeanName);
        }
    }

    @Test
    public void testGetMBeanJsonp() throws Exception {
        for (String mbeanName : this.getMBeanNames()) {
            URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.uriFor("/v1/jmx/mbean")).appendPath(mbeanName).build();
            JsonNode mbean = this.jsonpRequest(uri);
            JsonNode name = mbean.get("objectName");
            Assertions.assertThat((boolean)name.isTextual()).isTrue();
            Assertions.assertThat((String)name.asText()).isEqualTo(mbeanName);
        }
    }

    private JsonNode jsonRequest(URI uri) throws IOException {
        Request request = Request.Builder.prepareGet().setUri(uri).build();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.client.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        ((AbstractIntegerAssert)Assertions.assertThat((int)response.getStatusCode()).as(response.getBody(), new Object[0])).isEqualTo(200);
        TestMBeanResource.assertContentType(response, MediaType.JSON_UTF_8);
        return new ObjectMapperProvider().get().readTree(response.getBody());
    }

    private JsonNode jsonpRequest(URI uri) throws IOException {
        uri = HttpUriBuilder.uriBuilderFrom((URI)uri).addParameter("jsonp", new String[]{"test"}).build();
        Request request = Request.Builder.prepareGet().setUri(uri).build();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.client.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        ((AbstractIntegerAssert)Assertions.assertThat((int)response.getStatusCode()).as(response.getBody(), new Object[0])).isEqualTo(200);
        TestMBeanResource.assertContentType(response, MediaType.JSON_UTF_8);
        String jsonp = response.getBody().trim();
        Assertions.assertThat((String)jsonp).startsWith((CharSequence)"test(");
        Assertions.assertThat((String)jsonp).endsWith((CharSequence)")");
        jsonp = jsonp.substring(5, jsonp.length() - 1);
        return new ObjectMapperProvider().get().readTree(jsonp);
    }

    private URI uriFor(String path) {
        return this.server.getBaseUrl().resolve(path);
    }

    private List<String> getMBeanNames() {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ObjectName objectName : this.mbeanServer.queryNames(ObjectName.WILDCARD, null)) {
            list.add((Object)objectName.toString());
        }
        return list.build();
    }

    private static void assertContentType(StringResponseHandler.StringResponse response, MediaType type) {
        String contentType = response.getHeader("Content-Type");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)MediaType.parse((String)contentType).is(type.withoutParameters())).as(contentType, new Object[0])).isTrue();
    }
}

