/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.memory.jetty;

import io.airlift.memory.jetty.ConcurrentRetainableBufferPool;
import io.airlift.units.DataSize;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestPool {
    private static final int INITIAL_SIZE = 10;
    private static final int SIZE_FACTOR = 10;
    private static final int NUM_SIZES = 6;
    private ConcurrentRetainableBufferPool pool;
    private RetainableByteBuffer[] buffers;

    @BeforeAll
    public void setUp() {
        this.pool = new ConcurrentRetainableBufferPool(0L, 0L);
        this.buffers = new RetainableByteBuffer[6];
    }

    @Test
    public void testBasicAlloc() {
        int size = 10;
        int i = 0;
        while (i < this.buffers.length) {
            this.buffers[i] = this.pool.acquire(size, i % 2 == 0);
            Assertions.assertThat((Comparable)this.buffers[i].getByteBuffer()).isNotNull();
            Assertions.assertThat((int)this.buffers[i].getByteBuffer().capacity()).isEqualTo(this.getExpectedSize(size));
            ++i;
            size *= 10;
        }
        i = 0;
        while (i < this.buffers.length) {
            this.buffers[i].release();
            Assertions.assertThat((Comparable)this.buffers[i].getByteBuffer()).isNull();
            ++i;
            size *= 10;
        }
    }

    @Test
    public void testRetain() {
        int size = 10;
        int i = 0;
        while (i < this.buffers.length) {
            this.buffers[i] = this.pool.acquire(size, i % 2 == 0);
            Assertions.assertThat((Comparable)this.buffers[i].getByteBuffer()).isNotNull();
            Assertions.assertThat((int)this.buffers[i].getByteBuffer().capacity()).isEqualTo(this.getExpectedSize(size));
            Assertions.assertThat((boolean)this.buffers[i].canRetain()).isTrue();
            this.buffers[i].retain();
            Assertions.assertThat((boolean)this.buffers[i].isRetained()).isTrue();
            this.buffers[i].release();
            Assertions.assertThat((boolean)this.buffers[i].isRetained()).isFalse();
            Assertions.assertThat((Comparable)this.buffers[i].getByteBuffer()).isNotNull();
            ++i;
            size *= 10;
        }
        i = 0;
        while (i < this.buffers.length) {
            this.buffers[i].release();
            Assertions.assertThat((Comparable)this.buffers[i].getByteBuffer()).isNull();
            ++i;
            size *= 10;
        }
    }

    @Test
    public void testMaxMemory() {
        int bufferIx = 0;
        int size = (int)DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes() - 10;
        this.buffers[bufferIx] = this.pool.acquire(size, true);
        Assertions.assertThat((Comparable)this.buffers[bufferIx].getByteBuffer()).isNotNull();
        Assertions.assertThat((int)this.buffers[bufferIx].getByteBuffer().capacity()).isEqualTo(this.getExpectedSize(size));
        this.buffers[++bufferIx] = this.pool.acquire(size *= 4, true);
        Assertions.assertThat((Comparable)this.buffers[bufferIx].getByteBuffer()).isNotNull();
        Assertions.assertThat((int)this.buffers[bufferIx].getByteBuffer().capacity()).isEqualTo(this.getExpectedSize(size));
        ++bufferIx;
        while (bufferIx > 0) {
            this.buffers[--bufferIx].release();
            Assertions.assertThat((Comparable)this.buffers[bufferIx].getByteBuffer()).isNull();
        }
    }

    private int getExpectedSize(int size) {
        return Math.max(128, 1 << 32 - Integer.numberOfLeadingZeros(size - 1));
    }
}

