/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.server;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.drift.transport.MethodMetadata;
import io.airlift.drift.transport.server.ServerInvokeRequest;
import io.airlift.drift.transport.server.ServerMethodInvoker;
import io.airlift.drift.transport.server.ServerTransport;
import java.util.Map;
import java.util.Optional;

public class TestingServerTransport
implements ServerTransport {
    private final ServerMethodInvoker serverMethodInvoker;
    private State state = State.NOT_STARTED;

    public TestingServerTransport(ServerMethodInvoker serverMethodInvoker) {
        this.serverMethodInvoker = serverMethodInvoker;
    }

    public synchronized State getState() {
        return this.state;
    }

    public synchronized void start() {
        Preconditions.checkState((this.state == State.NOT_STARTED ? 1 : 0) != 0);
        this.state = State.RUNNING;
    }

    public synchronized ListenableFuture<Object> invoke(String methodName, Map<String, String> headers, Map<Short, Object> parameters) {
        long startTime = System.nanoTime();
        Optional methodMetadata = this.serverMethodInvoker.getMethodMetadata(methodName);
        Preconditions.checkArgument((boolean)methodMetadata.isPresent(), (String)"Method %s not found", (Object)methodName);
        ListenableFuture result = this.serverMethodInvoker.invoke(new ServerInvokeRequest((MethodMetadata)methodMetadata.get(), headers, parameters));
        this.serverMethodInvoker.recordResult(methodName, startTime, result);
        return result;
    }

    public synchronized void shutdown() {
        Preconditions.checkState((this.state == State.RUNNING ? 1 : 0) != 0);
        this.state = State.SHUTDOWN;
    }

    public static enum State {
        NOT_STARTED,
        RUNNING,
        SHUTDOWN;

    }
}

