/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.server;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.drift.TApplicationException;
import io.airlift.drift.TException;
import io.airlift.drift.annotations.ThriftException;
import io.airlift.drift.annotations.ThriftMethod;
import io.airlift.drift.annotations.ThriftService;
import io.airlift.drift.annotations.ThriftStruct;
import io.airlift.drift.codec.ThriftCodec;
import io.airlift.drift.codec.ThriftCodecManager;
import io.airlift.drift.server.DriftServer;
import io.airlift.drift.server.DriftService;
import io.airlift.drift.server.MethodInvocationFilter;
import io.airlift.drift.server.PassThroughFilter;
import io.airlift.drift.server.ResultsSupplier;
import io.airlift.drift.server.ShortCircuitFilter;
import io.airlift.drift.server.TestingInvocationTarget;
import io.airlift.drift.server.TestingMethodInvocationStat;
import io.airlift.drift.server.TestingMethodInvocationStatsFactory;
import io.airlift.drift.server.TestingServerTransport;
import io.airlift.drift.server.TestingServerTransportFactory;
import io.airlift.drift.server.guice.DriftServerBinder;
import io.airlift.drift.server.stats.MethodInvocationStatsFactory;
import io.airlift.drift.transport.server.ServerTransportFactory;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDriftServer {
    @Test
    public void testInvoker() throws Exception {
        ResultsSupplier resultsSupplier = new ResultsSupplier();
        TestService testService = new TestService(resultsSupplier);
        TestingServerTransportFactory serverTransportFactory = new TestingServerTransportFactory();
        TestingMethodInvocationStatsFactory statsFactory = new TestingMethodInvocationStatsFactory();
        DriftServer driftServer = new DriftServer((ServerTransportFactory)serverTransportFactory, new ThriftCodecManager(new ThriftCodec[0]), (MethodInvocationStatsFactory)statsFactory, (Set)ImmutableSet.of((Object)new DriftService((Object)testService, Optional.empty(), true)), (Set)ImmutableSet.of());
        TestingServerTransport serverTransport = serverTransportFactory.getServerTransport();
        Assert.assertNotNull((Object)serverTransport);
        Assert.assertEquals((Object)((Object)serverTransport.getState()), (Object)((Object)TestingServerTransport.State.NOT_STARTED));
        driftServer.start();
        Assert.assertEquals((Object)((Object)serverTransport.getState()), (Object)((Object)TestingServerTransport.State.RUNNING));
        TestDriftServer.testServer(resultsSupplier, testService, statsFactory, serverTransport);
        driftServer.shutdown();
        Assert.assertEquals((Object)((Object)serverTransport.getState()), (Object)((Object)TestingServerTransport.State.SHUTDOWN));
    }

    @Test
    public void testFilter() throws Exception {
        ResultsSupplier resultsSupplier = new ResultsSupplier();
        PassThroughFilter passThroughFilter = new PassThroughFilter();
        ShortCircuitFilter shortCircuitFilter = new ShortCircuitFilter(resultsSupplier);
        TestService testService = new TestService(() -> Futures.immediateFailedFuture((Throwable)new Exception("Should not be called")));
        TestingServerTransportFactory serverTransportFactory = new TestingServerTransportFactory();
        TestingMethodInvocationStatsFactory statsFactory = new TestingMethodInvocationStatsFactory();
        DriftServer driftServer = new DriftServer((ServerTransportFactory)serverTransportFactory, new ThriftCodecManager(new ThriftCodec[0]), (MethodInvocationStatsFactory)statsFactory, (Set)ImmutableSet.of((Object)new DriftService((Object)testService, Optional.empty(), true)), (Set)ImmutableSet.of((Object)passThroughFilter, (Object)shortCircuitFilter));
        TestingServerTransport serverTransport = serverTransportFactory.getServerTransport();
        Assert.assertNotNull((Object)serverTransport);
        Assert.assertEquals((Object)((Object)serverTransport.getState()), (Object)((Object)TestingServerTransport.State.NOT_STARTED));
        driftServer.start();
        Assert.assertEquals((Object)((Object)serverTransport.getState()), (Object)((Object)TestingServerTransport.State.RUNNING));
        TestDriftServer.testServer(resultsSupplier, TestingInvocationTarget.combineTestingInvocationTarget(passThroughFilter, shortCircuitFilter), statsFactory, serverTransport);
        driftServer.shutdown();
        Assert.assertEquals((Object)((Object)serverTransport.getState()), (Object)((Object)TestingServerTransport.State.SHUTDOWN));
    }

    @Test
    public void testGuiceServer() {
        ResultsSupplier resultsSupplier = new ResultsSupplier();
        TestService testService = new TestService(resultsSupplier);
        TestingServerTransportFactory serverTransportFactory = new TestingServerTransportFactory();
        TestingMethodInvocationStatsFactory statsFactory = new TestingMethodInvocationStatsFactory();
        Bootstrap app = new Bootstrap(new Module[]{binder -> binder.bind(TestService.class).toInstance((Object)testService), binder -> DriftServerBinder.driftServerBinder((Binder)binder).bindService(TestService.class), binder -> binder.bind(ServerTransportFactory.class).toInstance((Object)serverTransportFactory), binder -> OptionalBinder.newOptionalBinder((Binder)binder, MethodInvocationStatsFactory.class).setBinding().toInstance((Object)statsFactory)});
        LifeCycleManager lifeCycleManager = null;
        try {
            Injector injector = app.doNotInitializeLogging().initialize();
            lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            Assert.assertEquals((Object)((Object)serverTransportFactory.getServerTransport().getState()), (Object)((Object)TestingServerTransport.State.RUNNING));
            TestDriftServer.testServer(resultsSupplier, testService, statsFactory, serverTransportFactory.getServerTransport());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (lifeCycleManager != null) {
                try {
                    lifeCycleManager.stop();
                }
                catch (Exception exception) {}
            }
        }
        Assert.assertEquals((Object)((Object)serverTransportFactory.getServerTransport().getState()), (Object)((Object)TestingServerTransport.State.SHUTDOWN));
    }

    @Test
    public void testGuiceServerFilter() {
        ResultsSupplier resultsSupplier = new ResultsSupplier();
        PassThroughFilter passThroughFilter = new PassThroughFilter();
        ShortCircuitFilter shortCircuitFilter = new ShortCircuitFilter(resultsSupplier);
        TestService testService = new TestService(() -> Futures.immediateFailedFuture((Throwable)new Exception("Should not be called")));
        TestingServerTransportFactory serverTransportFactory = new TestingServerTransportFactory();
        TestingMethodInvocationStatsFactory statsFactory = new TestingMethodInvocationStatsFactory();
        Bootstrap app = new Bootstrap(new Module[]{binder -> binder.bind(TestService.class).toInstance((Object)testService), binder -> DriftServerBinder.driftServerBinder((Binder)binder).bindService(TestService.class), binder -> DriftServerBinder.driftServerBinder((Binder)binder).bindFilter((MethodInvocationFilter)passThroughFilter), binder -> DriftServerBinder.driftServerBinder((Binder)binder).bindFilter((MethodInvocationFilter)shortCircuitFilter), binder -> binder.bind(ServerTransportFactory.class).toInstance((Object)serverTransportFactory), binder -> OptionalBinder.newOptionalBinder((Binder)binder, MethodInvocationStatsFactory.class).setBinding().toInstance((Object)statsFactory)});
        LifeCycleManager lifeCycleManager = null;
        try {
            Injector injector = app.doNotInitializeLogging().initialize();
            lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            Assert.assertEquals((Object)((Object)serverTransportFactory.getServerTransport().getState()), (Object)((Object)TestingServerTransport.State.RUNNING));
            TestDriftServer.testServer(resultsSupplier, TestingInvocationTarget.combineTestingInvocationTarget(passThroughFilter, shortCircuitFilter), statsFactory, serverTransportFactory.getServerTransport());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (lifeCycleManager != null) {
                try {
                    lifeCycleManager.stop();
                }
                catch (Exception exception) {}
            }
        }
        Assert.assertEquals((Object)((Object)serverTransportFactory.getServerTransport().getState()), (Object)((Object)TestingServerTransport.State.SHUTDOWN));
    }

    private static void testServer(ResultsSupplier resultsSupplier, TestingInvocationTarget invocationTarget, TestingMethodInvocationStatsFactory statsFactory, TestingServerTransport serverTransport) throws ExecutionException {
        TestDriftServer.assertNormalInvocation(resultsSupplier, serverTransport, invocationTarget, statsFactory, Optional.empty());
        TestDriftServer.assertExceptionInvocation(resultsSupplier, serverTransport, invocationTarget, statsFactory, Optional.empty(), new TestServiceException());
        TestDriftServer.assertExceptionInvocation(resultsSupplier, serverTransport, invocationTarget, statsFactory, Optional.empty(), (Throwable)new TException());
        TestDriftServer.assertExceptionInvocation(resultsSupplier, serverTransport, invocationTarget, statsFactory, Optional.empty(), (Throwable)new TApplicationException());
        TestDriftServer.assertExceptionInvocation(resultsSupplier, serverTransport, invocationTarget, statsFactory, Optional.empty(), new RuntimeException());
        TestDriftServer.assertExceptionInvocation(resultsSupplier, serverTransport, invocationTarget, statsFactory, Optional.empty(), new Error());
        TestDriftServer.assertExceptionInvocation(resultsSupplier, serverTransport, invocationTarget, statsFactory, Optional.empty(), new TestServiceException(){});
    }

    private static void assertNormalInvocation(ResultsSupplier resultsSupplier, TestingServerTransport serverTransport, TestingInvocationTarget invocationTarget, TestingMethodInvocationStatsFactory statsFactory, Optional<String> qualifier) throws ExecutionException {
        TestingMethodInvocationStat testStat = statsFactory.getStat("serverService", qualifier, "test");
        testStat.clear();
        int invocationId = ThreadLocalRandom.current().nextInt();
        String expectedResult = "result " + invocationId;
        resultsSupplier.setSuccessResult(expectedResult);
        ListenableFuture<Object> result = serverTransport.invoke("test", (Map<String, String>)ImmutableMap.of(), (Map<Short, Object>)ImmutableMap.of((Object)1, (Object)invocationId, (Object)2, (Object)"normal"));
        Assert.assertTrue((boolean)result.isDone());
        Assert.assertEquals((Object)Futures.getDone(result), (Object)expectedResult);
        invocationTarget.assertInvocation("test", invocationId, "normal");
        testStat.assertSuccess();
        TestingMethodInvocationStat testAsyncStat = statsFactory.getStat("serverService", qualifier, "testAsync");
        testAsyncStat.clear();
        invocationId = ThreadLocalRandom.current().nextInt();
        expectedResult = "async " + expectedResult;
        resultsSupplier.setSuccessResult(expectedResult);
        ListenableFuture<Object> asyncResult = serverTransport.invoke("testAsync", (Map<String, String>)ImmutableMap.of(), (Map<Short, Object>)ImmutableMap.of((Object)1, (Object)invocationId, (Object)2, (Object)"async"));
        Assert.assertTrue((boolean)asyncResult.isDone());
        Assert.assertEquals((Object)Futures.getDone(asyncResult), (Object)expectedResult);
        invocationTarget.assertInvocation("testAsync", invocationId, "async");
        testAsyncStat.assertSuccess();
    }

    private static void assertExceptionInvocation(ResultsSupplier resultsSupplier, TestingServerTransport serverTransport, TestingInvocationTarget invocationTarget, TestingMethodInvocationStatsFactory statsFactory, Optional<String> qualifier, Throwable testException) {
        String name = "exception-" + testException.getClass().getName();
        TestingMethodInvocationStat testStat = statsFactory.getStat("serverService", qualifier, "test");
        testStat.clear();
        int invocationId = ThreadLocalRandom.current().nextInt();
        resultsSupplier.setFailedResult(testException);
        ListenableFuture<Object> result = serverTransport.invoke("test", (Map<String, String>)ImmutableMap.of(), (Map<Short, Object>)ImmutableMap.of((Object)1, (Object)invocationId, (Object)2, (Object)name));
        Assert.assertTrue((boolean)result.isDone());
        try {
            Futures.getDone(result);
            Assert.fail((String)"expected exception");
        }
        catch (ExecutionException e) {
            Assert.assertSame((Object)e.getCause(), (Object)testException);
        }
        invocationTarget.assertInvocation("test", invocationId, name);
        testStat.assertFailure();
        name = "async " + name;
        TestingMethodInvocationStat testAsyncStat = statsFactory.getStat("serverService", qualifier, "testAsync");
        testAsyncStat.clear();
        invocationId = ThreadLocalRandom.current().nextInt();
        resultsSupplier.setFailedResult(testException);
        ListenableFuture<Object> asyncResult = serverTransport.invoke("testAsync", (Map<String, String>)ImmutableMap.of(), (Map<Short, Object>)ImmutableMap.of((Object)1, (Object)invocationId, (Object)2, (Object)name));
        Assert.assertTrue((boolean)asyncResult.isDone());
        try {
            Futures.getDone(result);
            Assert.fail((String)"expected exception");
        }
        catch (ExecutionException e) {
            Assert.assertSame((Object)e.getCause(), (Object)testException);
        }
        invocationTarget.assertInvocation("testAsync", invocationId, name);
        testAsyncStat.assertFailure();
    }

    @ThriftService(value="serverService")
    public static class TestService
    implements TestingInvocationTarget {
        private final Supplier<ListenableFuture<Object>> resultsSupplier;
        private String methodName;
        private int id;
        private String name;

        public TestService(Supplier<ListenableFuture<Object>> resultsSupplier) {
            this.resultsSupplier = resultsSupplier;
        }

        @ThriftMethod
        public String test(int id, String name) throws TestServiceException, TException {
            this.methodName = "test";
            this.id = id;
            this.name = name;
            try {
                return (String)Futures.getDone((Future)((Future)this.resultsSupplier.get()));
            }
            catch (ExecutionException e) {
                Throwable failureResult = e.getCause();
                Throwables.propagateIfPossible((Throwable)failureResult, TestServiceException.class);
                Throwables.propagateIfPossible((Throwable)failureResult, TException.class);
                throw new RuntimeException(failureResult);
            }
        }

        @ThriftMethod(exception={@ThriftException(id=0, type=TestServiceException.class)})
        public ListenableFuture<String> testAsync(int id, String name) {
            this.methodName = "testAsync";
            this.id = id;
            this.name = name;
            return Futures.transform(this.resultsSupplier.get(), String::valueOf, (Executor)MoreExecutors.directExecutor());
        }

        @Override
        public void assertInvocation(String expectedMethodName, int expectedId, String expectedName) {
            Assert.assertEquals((String)this.methodName, (String)expectedMethodName);
            Assert.assertEquals((int)this.id, (int)expectedId);
            Assert.assertEquals((String)this.name, (String)expectedName);
        }
    }

    @ThriftStruct(value="testService")
    public static class TestServiceException
    extends Exception {
    }
}

