/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.server;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.drift.server.stats.MethodInvocationStat;
import io.airlift.testing.Assertions;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.testng.Assert;

public class TestingMethodInvocationStat
implements MethodInvocationStat {
    private final AtomicInteger invocations = new AtomicInteger();
    private final AtomicInteger successes = new AtomicInteger();
    private final AtomicInteger failures = new AtomicInteger();
    private final AtomicLong lastStartTime = new AtomicLong();

    public void clear() {
        this.invocations.set(0);
        this.successes.set(0);
        this.failures.set(0);
        this.lastStartTime.set(0L);
    }

    public void assertSuccess() {
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(this.invocations.get()), (Comparable)Integer.valueOf(0));
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(this.successes.get()), (Comparable)Integer.valueOf(0));
        Assert.assertEquals((int)this.failures.get(), (int)0);
        Assert.assertNotEquals((Object)this.lastStartTime.get(), (Object)0);
    }

    public void assertFailure() {
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(this.invocations.get()), (Comparable)Integer.valueOf(0));
        Assert.assertEquals((int)this.successes.get(), (int)0);
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(this.failures.get()), (Comparable)Integer.valueOf(0));
        Assert.assertNotEquals((Object)this.lastStartTime.get(), (Object)0);
    }

    public void recordResult(long startTime, ListenableFuture<Object> result) {
        this.invocations.incrementAndGet();
        result.addListener(() -> {
            this.lastStartTime.set(startTime);
            try {
                result.get();
                this.successes.incrementAndGet();
            }
            catch (Throwable throwable) {
                this.failures.incrementAndGet();
            }
        }, MoreExecutors.directExecutor());
    }
}

