/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import io.airlift.discovery.client.ServiceType;
import io.airlift.discovery.client.ServiceTypes;
import io.airlift.testing.EquivalenceTester;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestServiceTypes {
    @ServiceType(value="apple")
    private final ServiceType appleServiceType;
    @ServiceType(value="banana")
    private final ServiceType bananaServiceType;
    @ServiceType(value="quot\"ation-and-\\backslash")
    private final ServiceType serviceTypeWithCharacters;

    public TestServiceTypes() {
        try {
            this.appleServiceType = this.getClass().getDeclaredField("appleServiceType").getAnnotation(ServiceType.class);
            this.bananaServiceType = this.getClass().getDeclaredField("bananaServiceType").getAnnotation(ServiceType.class);
            this.serviceTypeWithCharacters = this.getClass().getDeclaredField("serviceTypeWithCharacters").getAnnotation(ServiceType.class);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testValue() {
        Assert.assertEquals((String)ServiceTypes.serviceType((String)"type").value(), (String)"type");
    }

    @Test
    public void testAnnotationType() {
        Assert.assertEquals((Object)ServiceTypes.serviceType((String)"apple").annotationType(), ServiceType.class);
        Assert.assertEquals((Object)ServiceTypes.serviceType((String)"apple").annotationType(), (Object)this.appleServiceType.annotationType());
    }

    @Test
    public void testEquivalence() {
        EquivalenceTester.equivalenceTester().addEquivalentGroup((Object)this.appleServiceType, new Object[]{ServiceTypes.serviceType((String)"apple")}).addEquivalentGroup((Object)this.bananaServiceType, new Object[]{ServiceTypes.serviceType((String)"banana")}).check();
    }
}

