/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceState;
import io.airlift.json.JsonCodec;
import io.airlift.node.NodeConfig;
import io.airlift.node.NodeInfo;
import io.airlift.testing.EquivalenceTester;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestServiceDescriptor {
    private final JsonCodec<ServiceDescriptor> serviceDescriptorCodec = JsonCodec.jsonCodec(ServiceDescriptor.class);

    @Test
    public void testJsonDecode() throws Exception {
        ServiceDescriptor expected = new ServiceDescriptor(UUID.fromString("12345678-1234-1234-1234-123456789012"), "node", "type", "pool", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple", (Object)"b", (Object)"banana"));
        String json = Resources.toString((URL)Resources.getResource((String)"service-descriptor.json"), (Charset)StandardCharsets.UTF_8);
        ServiceDescriptor actual = (ServiceDescriptor)this.serviceDescriptorCodec.fromJson(json);
        TestServiceDescriptor.assertDescriptorEquals(expected, actual);
    }

    @Test
    public void testToString() {
        Assert.assertNotNull((Object)new ServiceDescriptor(UUID.fromString("12345678-1234-1234-1234-123456789012"), "node", "type", "pool", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple", (Object)"b", (Object)"banana")));
    }

    @Test
    public void testEquivalence() {
        UUID serviceA = UUID.randomUUID();
        UUID serviceB = UUID.randomUUID();
        EquivalenceTester.equivalenceTester().addEquivalentGroup((Object)new ServiceDescriptor(serviceA, "node", "type", "pool", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple")), new Object[]{new ServiceDescriptor(serviceA, "node-X", "type", "pool", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple")), new ServiceDescriptor(serviceA, "node", "type-X", "pool", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple")), new ServiceDescriptor(serviceA, "node", "type", "pool-X", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple")), new ServiceDescriptor(serviceA, "node", "type", "pool", "location-X", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple")), new ServiceDescriptor(serviceA, "node", "type", "pool", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a-X", (Object)"apple")), new ServiceDescriptor(serviceA, "node", "type", "pool", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple-X"))}).addEquivalentGroup((Object)new ServiceDescriptor(serviceB, "node", "type", "pool", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple")), new Object[]{new ServiceDescriptor(serviceB, "node-X", "type", "pool", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple")), new ServiceDescriptor(serviceB, "node", "type-X", "pool", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple")), new ServiceDescriptor(serviceB, "node", "type", "pool-X", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple")), new ServiceDescriptor(serviceB, "node", "type", "pool", "location-X", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple")), new ServiceDescriptor(serviceB, "node", "type", "pool", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a-X", (Object)"apple")), new ServiceDescriptor(serviceB, "node", "type", "pool", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple-X"))}).check();
    }

    @Test
    public void testBuilderNodeId() {
        ServiceDescriptor expected = new ServiceDescriptor(UUID.fromString("12345678-1234-1234-1234-123456789012"), "node", "type", "pool", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple", (Object)"b", (Object)"banana"));
        ServiceDescriptor.ServiceDescriptorBuilder builder = ServiceDescriptor.serviceDescriptor((String)expected.getType()).setId(expected.getId()).setLocation(expected.getLocation()).setNodeId(expected.getNodeId()).setPool(expected.getPool()).setState(expected.getState());
        for (Map.Entry entry : expected.getProperties().entrySet()) {
            builder.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        TestServiceDescriptor.assertDescriptorEquals(expected, builder.build());
    }

    @Test
    public void testBuilderNodeInfo() {
        NodeInfo nodeInfo = new NodeInfo(new NodeConfig().setEnvironment("test").setPool("pool"));
        ServiceDescriptor expected = new ServiceDescriptor(UUID.fromString("12345678-1234-1234-1234-123456789012"), nodeInfo.getNodeId(), "type", nodeInfo.getPool(), "location", ServiceState.STOPPED, (Map)ImmutableMap.of((Object)"a", (Object)"apple", (Object)"b", (Object)"banana"));
        ServiceDescriptor actual = ServiceDescriptor.serviceDescriptor((String)expected.getType()).setId(expected.getId()).setLocation(expected.getLocation()).setNodeInfo(nodeInfo).setState(expected.getState()).addProperties(expected.getProperties()).build();
        TestServiceDescriptor.assertDescriptorEquals(expected, actual);
    }

    private static void assertDescriptorEquals(ServiceDescriptor expected, ServiceDescriptor actual) {
        Assert.assertEquals((Object)actual, (Object)expected);
        Assert.assertEquals((Object)actual.getId(), (Object)expected.getId());
        Assert.assertEquals((String)actual.getNodeId(), (String)expected.getNodeId());
        Assert.assertEquals((String)actual.getType(), (String)expected.getType());
        Assert.assertEquals((String)actual.getPool(), (String)expected.getPool());
        Assert.assertEquals((String)actual.getLocation(), (String)expected.getLocation());
        Assert.assertEquals((Map)actual.getProperties(), (Map)expected.getProperties());
    }
}

