/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.collect.MoreCollectors;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import io.airlift.discovery.client.AnnouncementHttpServerInfo;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.discovery.client.StaticAnnouncementHttpServerInfoImpl;
import io.airlift.discovery.client.testing.TestingDiscoveryModule;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHttpAnnouncementBinder {
    @Test
    public void testHttpAnnouncement() {
        StaticAnnouncementHttpServerInfoImpl httpServerInfo = new StaticAnnouncementHttpServerInfoImpl(URI.create("http://127.0.0.1:4444"), URI.create("http://example.com:4444"), null, null);
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestingDiscoveryModule(), binder -> {
            binder.bind(AnnouncementHttpServerInfo.class).toInstance((Object)httpServerInfo);
            DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("apple");
        }});
        ServiceAnnouncement announcement = ServiceAnnouncement.serviceAnnouncement((String)"apple").addProperty("http", httpServerInfo.getHttpUri().toASCIIString()).addProperty("http-external", httpServerInfo.getHttpExternalUri().toASCIIString()).build();
        Set announcements = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<ServiceAnnouncement>>(){}));
        this.assertAnnouncement(announcements, announcement);
    }

    @Test
    public void testHttpsAnnouncement() {
        StaticAnnouncementHttpServerInfoImpl httpServerInfo = new StaticAnnouncementHttpServerInfoImpl(null, null, URI.create("https://127.0.0.1:4444"), URI.create("https://example.com:4444"));
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestingDiscoveryModule(), binder -> {
            binder.bind(AnnouncementHttpServerInfo.class).toInstance((Object)httpServerInfo);
            DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("apple");
        }});
        ServiceAnnouncement announcement = ServiceAnnouncement.serviceAnnouncement((String)"apple").addProperty("https", httpServerInfo.getHttpsUri().toASCIIString()).addProperty("https-external", httpServerInfo.getHttpsExternalUri().toASCIIString()).build();
        Set announcements = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<ServiceAnnouncement>>(){}));
        this.assertAnnouncement(announcements, announcement);
    }

    @Test
    public void testHttpAnnouncementWithPool() {
        StaticAnnouncementHttpServerInfoImpl httpServerInfo = new StaticAnnouncementHttpServerInfoImpl(URI.create("http://127.0.0.1:4444"), URI.create("http://example.com:4444"), URI.create("https://127.0.0.1:4444"), URI.create("https://example.com:4444"));
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestingDiscoveryModule(), binder -> {
            binder.bind(AnnouncementHttpServerInfo.class).toInstance((Object)httpServerInfo);
            DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("apple");
        }});
        ServiceAnnouncement announcement = ServiceAnnouncement.serviceAnnouncement((String)"apple").addProperty("http", httpServerInfo.getHttpUri().toASCIIString()).addProperty("http-external", httpServerInfo.getHttpExternalUri().toASCIIString()).addProperty("https", httpServerInfo.getHttpsUri().toASCIIString()).addProperty("https-external", httpServerInfo.getHttpsExternalUri().toASCIIString()).build();
        Set announcements = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<ServiceAnnouncement>>(){}));
        this.assertAnnouncement(announcements, announcement);
    }

    @Test
    public void testHttpAnnouncementWithCustomProperties() {
        StaticAnnouncementHttpServerInfoImpl httpServerInfo = new StaticAnnouncementHttpServerInfoImpl(URI.create("http://127.0.0.1:4444"), URI.create("http://example.com:4444"), URI.create("https://127.0.0.1:4444"), URI.create("https://example.com:4444"));
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestingDiscoveryModule(), binder -> {
            binder.bind(AnnouncementHttpServerInfo.class).toInstance((Object)httpServerInfo);
            DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("apple").addProperty("a", "apple");
        }});
        ServiceAnnouncement announcement = ServiceAnnouncement.serviceAnnouncement((String)"apple").addProperty("a", "apple").addProperty("http", httpServerInfo.getHttpUri().toASCIIString()).addProperty("http-external", httpServerInfo.getHttpExternalUri().toASCIIString()).addProperty("https", httpServerInfo.getHttpsUri().toASCIIString()).addProperty("https-external", httpServerInfo.getHttpsExternalUri().toASCIIString()).build();
        Set announcements = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<ServiceAnnouncement>>(){}));
        this.assertAnnouncement(announcements, announcement);
    }

    private void assertAnnouncement(Set<ServiceAnnouncement> actualAnnouncements, ServiceAnnouncement expected) {
        Assert.assertNotNull(actualAnnouncements);
        Assert.assertEquals((int)actualAnnouncements.size(), (int)1);
        ServiceAnnouncement announcement = (ServiceAnnouncement)actualAnnouncements.stream().collect(MoreCollectors.onlyElement());
        Assert.assertEquals((String)announcement.getType(), (String)expected.getType());
        Assert.assertEquals((Map)announcement.getProperties(), (Map)expected.getProperties());
    }
}

