/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.discovery.client.AbstractTestDiscoveryModule;
import io.airlift.discovery.client.DiscoveryModule;
import io.airlift.discovery.client.ForDiscoveryClient;
import io.airlift.json.JsonModule;
import io.airlift.node.testing.TestingNodeModule;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDiscoveryModule
extends AbstractTestDiscoveryModule {
    protected TestDiscoveryModule() {
        super((Module)new DiscoveryModule());
    }

    @Test
    public void testExecutorShutdown() {
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new TestingNodeModule(), new DiscoveryModule()});
        Injector injector = app.doNotInitializeLogging().initialize();
        ExecutorService executor = (ExecutorService)injector.getInstance(Key.get(ScheduledExecutorService.class, ForDiscoveryClient.class));
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        Assert.assertFalse((boolean)executor.isShutdown());
        lifeCycleManager.stop();
        Assert.assertTrue((boolean)executor.isShutdown());
    }
}

