/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceTypes;
import io.airlift.discovery.client.testing.TestingDiscoveryModule;
import io.airlift.node.testing.TestingNodeModule;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDiscoveryBinder {
    private static final ServiceAnnouncement ANNOUNCEMENT = ServiceAnnouncement.serviceAnnouncement((String)"apple").addProperty("a", "apple").build();

    @Test
    public void testBindSelector() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestModule(), binder -> DiscoveryBinder.discoveryBinder((Binder)binder).bindServiceAnnouncement(new ServiceAnnouncementProvider().get())});
        Set announcements = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<ServiceAnnouncement>>(){}));
        Assert.assertEquals((Set)announcements, (Set)ImmutableSet.of((Object)ANNOUNCEMENT));
    }

    @Test
    public void testBindSelectorProviderClass() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestModule(), binder -> DiscoveryBinder.discoveryBinder((Binder)binder).bindServiceAnnouncement(ServiceAnnouncementProvider.class)});
        Set announcements = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<ServiceAnnouncement>>(){}));
        Assert.assertEquals((Set)announcements, (Set)ImmutableSet.of((Object)ANNOUNCEMENT));
    }

    @Test
    public void testBindSelectorProviderInstance() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestModule(), binder -> DiscoveryBinder.discoveryBinder((Binder)binder).bindServiceAnnouncement((Provider)new ServiceAnnouncementProvider())});
        Set announcements = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<ServiceAnnouncement>>(){}));
        Assert.assertEquals((Set)announcements, (Set)ImmutableSet.of((Object)ANNOUNCEMENT));
    }

    @Test
    public void testBindSelectorString() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestModule(), binder -> DiscoveryBinder.discoveryBinder((Binder)binder).bindSelector("apple")});
        this.assertCanCreateServiceSelector(injector, "apple", "general");
    }

    @Test
    public void testBindSelectorAnnotation() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestModule(), binder -> DiscoveryBinder.discoveryBinder((Binder)binder).bindSelector(ServiceTypes.serviceType((String)"apple"))});
        this.assertCanCreateServiceSelector(injector, "apple", "general");
    }

    @Test
    public void testBindSelectorStringWithPool() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestModule((Map<String, String>)ImmutableMap.of((Object)"discovery.apple.pool", (Object)"apple-pool")), binder -> DiscoveryBinder.discoveryBinder((Binder)binder).bindSelector("apple")});
        this.assertCanCreateServiceSelector(injector, "apple", "apple-pool");
    }

    @Test
    public void testBindSelectorAnnotationWithPool() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestModule((Map<String, String>)ImmutableMap.of((Object)"discovery.apple.pool", (Object)"apple-pool")), binder -> DiscoveryBinder.discoveryBinder((Binder)binder).bindSelector(ServiceTypes.serviceType((String)"apple"))});
        this.assertCanCreateServiceSelector(injector, "apple", "apple-pool");
    }

    private void assertCanCreateServiceSelector(Injector injector, String expectedType, String expectedPool) {
        ServiceSelector actualServiceSelector = (ServiceSelector)injector.getInstance(Key.get(ServiceSelector.class, (Annotation)ServiceTypes.serviceType((String)expectedType)));
        Assert.assertNotNull((Object)actualServiceSelector);
        Assert.assertEquals((String)actualServiceSelector.getType(), (String)expectedType);
        Assert.assertEquals((String)actualServiceSelector.getPool(), (String)expectedPool);
    }

    private static class TestModule
    implements Module {
        private Map<String, String> configProperties;

        private TestModule() {
            this.configProperties = ImmutableMap.of();
        }

        private TestModule(Map<String, String> configProperties) {
            this.configProperties = ImmutableMap.copyOf(configProperties);
        }

        public void configure(Binder binder) {
            binder.install((Module)new ConfigurationModule(new ConfigurationFactory(this.configProperties)));
            binder.install((Module)new TestingNodeModule());
            binder.install((Module)new TestingDiscoveryModule());
        }
    }

    private static class ServiceAnnouncementProvider
    implements Provider<ServiceAnnouncement> {
        private ServiceAnnouncementProvider() {
        }

        public ServiceAnnouncement get() {
            return ANNOUNCEMENT;
        }
    }
}

