/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.airlift.discovery.client.CachingServiceSelector;
import io.airlift.discovery.client.DiscoveryLookupClient;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceSelectorConfig;
import io.airlift.discovery.client.ServiceState;
import io.airlift.discovery.client.testing.InMemoryDiscoveryClient;
import io.airlift.node.NodeInfo;
import io.airlift.testing.Assertions;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestCachingServiceSelector {
    private static final ServiceDescriptor APPLE_1_SERVICE = new ServiceDescriptor(UUID.randomUUID(), "node-A", "apple", "pool", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple"));
    private static final ServiceDescriptor APPLE_2_SERVICE = new ServiceDescriptor(UUID.randomUUID(), "node-B", "apple", "pool", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple"));
    private static final ServiceDescriptor DIFFERENT_TYPE = new ServiceDescriptor(UUID.randomUUID(), "node-A", "banana", "pool", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"b", (Object)"banana"));
    private static final ServiceDescriptor DIFFERENT_POOL = new ServiceDescriptor(UUID.randomUUID(), "node-B", "apple", "fool", "location", ServiceState.RUNNING, (Map)ImmutableMap.of((Object)"a", (Object)"apple"));
    private ScheduledExecutorService executor;
    private NodeInfo nodeInfo;

    @BeforeClass
    protected void setUp() throws Exception {
        this.executor = new ScheduledThreadPoolExecutor(10, Threads.daemonThreadsNamed((String)"Discovery-%s"));
        this.nodeInfo = new NodeInfo("environment");
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.executor.shutdownNow();
    }

    @Test
    public void testBasics() {
        CachingServiceSelector serviceSelector = new CachingServiceSelector("type", new ServiceSelectorConfig().setPool("pool"), (DiscoveryLookupClient)new InMemoryDiscoveryClient(this.nodeInfo), this.executor);
        Assert.assertEquals((String)serviceSelector.getType(), (String)"type");
        Assert.assertEquals((String)serviceSelector.getPool(), (String)"pool");
    }

    @Test
    public void testNotStartedEmpty() {
        CachingServiceSelector serviceSelector = new CachingServiceSelector("type", new ServiceSelectorConfig().setPool("pool"), (DiscoveryLookupClient)new InMemoryDiscoveryClient(this.nodeInfo), this.executor);
        Assert.assertEquals((Collection)serviceSelector.selectAllServices(), (Collection)ImmutableList.of());
    }

    @Test
    public void testStartedEmpty() throws Exception {
        CachingServiceSelector serviceSelector = new CachingServiceSelector("type", new ServiceSelectorConfig().setPool("pool"), (DiscoveryLookupClient)new InMemoryDiscoveryClient(this.nodeInfo), this.executor);
        serviceSelector.start();
        Assert.assertEquals((Collection)serviceSelector.selectAllServices(), (Collection)ImmutableList.of());
    }

    @Test
    public void testNotStartedWithServices() {
        InMemoryDiscoveryClient discoveryClient = new InMemoryDiscoveryClient(this.nodeInfo);
        discoveryClient.addDiscoveredService(APPLE_1_SERVICE);
        discoveryClient.addDiscoveredService(APPLE_2_SERVICE);
        discoveryClient.addDiscoveredService(DIFFERENT_TYPE);
        discoveryClient.addDiscoveredService(DIFFERENT_POOL);
        CachingServiceSelector serviceSelector = new CachingServiceSelector("apple", new ServiceSelectorConfig().setPool("pool"), (DiscoveryLookupClient)discoveryClient, this.executor);
        Assert.assertEquals((Collection)serviceSelector.selectAllServices(), (Collection)ImmutableList.of());
    }

    @Test
    public void testStartedWithServices() throws Exception {
        InMemoryDiscoveryClient discoveryClient = new InMemoryDiscoveryClient(this.nodeInfo);
        discoveryClient.addDiscoveredService(APPLE_1_SERVICE);
        discoveryClient.addDiscoveredService(APPLE_2_SERVICE);
        discoveryClient.addDiscoveredService(DIFFERENT_TYPE);
        discoveryClient.addDiscoveredService(DIFFERENT_POOL);
        CachingServiceSelector serviceSelector = new CachingServiceSelector("apple", new ServiceSelectorConfig().setPool("pool"), (DiscoveryLookupClient)discoveryClient, this.executor);
        serviceSelector.start();
        Thread.sleep(100L);
        Assertions.assertEqualsIgnoreOrder((Iterable)serviceSelector.selectAllServices(), (Iterable)ImmutableList.of((Object)APPLE_1_SERVICE, (Object)APPLE_2_SERVICE));
    }
}

