/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.common.io.Resources;
import io.airlift.discovery.client.Announcement;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.json.JsonCodec;
import io.airlift.testing.EquivalenceTester;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAnnouncement {
    private final JsonCodec<Announcement> announcementCodec = JsonCodec.jsonCodec(Announcement.class);
    private final JsonCodec<Map<String, Object>> objectCodec = JsonCodec.mapJsonCodec(String.class, Object.class);

    @Test
    public void testJsonEncode() throws Exception {
        Announcement announcement = new Announcement("environment", "node", "pool", "location", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").addProperty("http", "http://localhost:8080").addProperty("jmx", "jmx://localhost:1234").build()));
        Map actual = (Map)this.objectCodec.fromJson(this.announcementCodec.toJson((Object)announcement));
        String json = Resources.toString((URL)Resources.getResource((String)"announcement.json"), (Charset)StandardCharsets.UTF_8);
        Map expected = (Map)this.objectCodec.fromJson(json);
        List<Map<String, Object>> services = TestAnnouncement.toServices(expected.get("services"));
        services.get(0).put("id", ((ServiceAnnouncement)announcement.getServices().stream().collect(MoreCollectors.onlyElement())).getId().toString());
        Assert.assertEquals((Map)actual, (Map)expected);
    }

    private static List<Map<String, Object>> toServices(Object value) {
        return (List)value;
    }

    @Test
    public void testToString() {
        Assert.assertNotNull((Object)new Announcement("environment", "node", "pool", "location", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").addProperty("http", "http://localhost:8080").addProperty("jmx", "jmx://localhost:1234").build())));
    }

    @Test
    public void testEquivalence() {
        EquivalenceTester.equivalenceTester().addEquivalentGroup((Object)new Announcement("environment", "node-A", "pool", "location", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").build())), new Object[]{new Announcement("ENVIRONMENT", "node-A", "pool", "location", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").build())), new Announcement("environment", "node-A", "pool", "LOCATION", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").build())), new Announcement("environment", "node-A", "pool", "location", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"FOO").build()))}).addEquivalentGroup((Object)new Announcement("environment", "node-B", "pool", "location", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").build())), new Object[]{new Announcement("environment-X", "node-B", "pool", "location", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").build())), new Announcement("environment", "node-B", "pool", "location-X", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").build())), new Announcement("environment", "node-B", "pool", "location", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"bar").build()))}).check();
    }
}

