/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.discovery.client.AnnouncementHttpServerInfo;
import io.airlift.discovery.client.Announcer;
import io.airlift.discovery.client.DiscoveryAnnouncementClient;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.client.DiscoveryLookupClient;
import io.airlift.discovery.client.DiscoveryModule;
import io.airlift.discovery.client.HttpServiceSelector;
import io.airlift.discovery.client.ServiceSelectorManager;
import io.airlift.discovery.client.ServiceTypes;
import io.airlift.discovery.client.StaticAnnouncementHttpServerInfoImpl;
import io.airlift.json.JsonModule;
import io.airlift.node.testing.TestingNodeModule;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestDiscoveryModule {
    private final Module discoveryModule;

    protected AbstractTestDiscoveryModule(Module discoveryModule) {
        this.discoveryModule = Objects.requireNonNull(discoveryModule, "discoveryModule is null");
    }

    @Test
    public void testBinding() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigurationModule(new ConfigurationFactory((Map)ImmutableMap.of((Object)"discovery.uri", (Object)"fake://server"))), new JsonModule(), new TestingNodeModule(), this.discoveryModule});
        Assert.assertNotNull((Object)injector.getInstance(DiscoveryAnnouncementClient.class));
        Assert.assertNotNull((Object)injector.getInstance(DiscoveryLookupClient.class));
        Assert.assertNotNull((Object)injector.getInstance(Announcer.class));
        Assert.assertNotNull((Object)injector.getInstance(ServiceSelectorManager.class));
    }

    @Test
    public void testMerging() throws Exception {
        StaticAnnouncementHttpServerInfoImpl httpServerInfo = new StaticAnnouncementHttpServerInfoImpl(URI.create("http://127.0.0.1:4444"), URI.create("http://example.com:4444"), null, null);
        ImmutableMap config = ImmutableMap.builder().put((Object)"discovery.uri", (Object)"fake://server").put((Object)"discovery.carrot.pool", (Object)"test").build();
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigurationModule(new ConfigurationFactory((Map)config)), new JsonModule(), new TestingNodeModule(), new DiscoveryModule(), binder -> {
            binder.bind(AnnouncementHttpServerInfo.class).toInstance((Object)httpServerInfo);
            DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("apple");
            DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("banana");
            DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("carrot");
            DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpSelector("apple");
            DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpSelector("banana");
            DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpSelector("carrot");
            DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpSelector("grape");
        }});
        HttpServiceSelector selector = (HttpServiceSelector)injector.getInstance(Key.get(HttpServiceSelector.class, (Annotation)ServiceTypes.serviceType((String)"apple")));
        Assert.assertEquals(selector.selectHttpService().stream().collect(MoreCollectors.onlyElement()), (Object)URI.create("http://127.0.0.1:4444"));
        selector = (HttpServiceSelector)injector.getInstance(Key.get(HttpServiceSelector.class, (Annotation)ServiceTypes.serviceType((String)"banana")));
        Assert.assertEquals(selector.selectHttpService().stream().collect(MoreCollectors.onlyElement()), (Object)URI.create("http://127.0.0.1:4444"));
        selector = (HttpServiceSelector)injector.getInstance(Key.get(HttpServiceSelector.class, (Annotation)ServiceTypes.serviceType((String)"carrot")));
        Assert.assertTrue((boolean)selector.selectHttpService().isEmpty());
        selector = (HttpServiceSelector)injector.getInstance(Key.get(HttpServiceSelector.class, (Annotation)ServiceTypes.serviceType((String)"grape")));
        Assert.assertTrue((boolean)selector.selectHttpService().isEmpty());
    }
}

