/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import io.airlift.bootstrap.AnInstance;
import io.airlift.bootstrap.AnotherInstance;
import io.airlift.bootstrap.BarInstance;
import io.airlift.bootstrap.BarProvider;
import io.airlift.bootstrap.DependentBoundInstance;
import io.airlift.bootstrap.DependentInstance;
import io.airlift.bootstrap.DependentInstanceImpl;
import io.airlift.bootstrap.DestroyExceptionInstance;
import io.airlift.bootstrap.ExecutedInstance;
import io.airlift.bootstrap.FooTestInstance;
import io.airlift.bootstrap.IllegalInstance;
import io.airlift.bootstrap.InstanceOne;
import io.airlift.bootstrap.InstanceThatRequiresStart;
import io.airlift.bootstrap.InstanceThatUsesInstanceThatRequiresStart;
import io.airlift.bootstrap.InstanceTwo;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.bootstrap.LifeCycleModule;
import io.airlift.bootstrap.LifeCycleStartException;
import io.airlift.bootstrap.LifeCycleStopException;
import io.airlift.bootstrap.PostConstructExceptionInstance;
import io.airlift.bootstrap.PostConstructOnly;
import io.airlift.bootstrap.PreDestroyOnly;
import io.airlift.bootstrap.SimpleBase;
import io.airlift.bootstrap.SimpleBaseImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ClassAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestLifeCycleManager {
    private static final List<String> stateLog = new CopyOnWriteArrayList<String>();

    @BeforeEach
    public void setup() {
        stateLog.clear();
    }

    static void note(String str) {
        stateLog.add(str);
    }

    @Test
    public void testImmediateStarts() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(InstanceThatRequiresStart.class).in(Scopes.SINGLETON);
            binder.bind(InstanceThatUsesInstanceThatRequiresStart.class).in(Scopes.SINGLETON);
        }});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"InstanceThatUsesInstanceThatRequiresStart:OK"));
    }

    @Test
    public void testPrivateModule() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> binder.install((Module)new PrivateModule(this){

            protected void configure() {
                this.binder().bind(SimpleBase.class).to(SimpleBaseImpl.class).in(Scopes.SINGLETON);
                this.binder().expose(SimpleBase.class);
            }
        })});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"postSimpleBaseImpl"));
        lifeCycleManager.stop();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"postSimpleBaseImpl", (Object)"preSimpleBaseImpl"));
    }

    @Test
    public void testSubClassAnnotated() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> binder.bind(SimpleBase.class).to(SimpleBaseImpl.class).in(Scopes.SINGLETON)});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"postSimpleBaseImpl"));
        lifeCycleManager.stop();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"postSimpleBaseImpl", (Object)"preSimpleBaseImpl"));
    }

    @Test
    public void testExecuted() throws Exception {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> binder.bind(ExecutedInstance.class).in(Scopes.SINGLETON)});
        ExecutedInstance instance = (ExecutedInstance)injector.getInstance(ExecutedInstance.class);
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        instance.waitForStart();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"Starting"));
        lifeCycleManager.stop();
        instance.waitForEnd();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"Starting", (Object)"Done"));
    }

    @Test
    public void testDeepDependency() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(AnInstance.class).in(Scopes.SINGLETON);
            binder.bind(AnotherInstance.class).in(Scopes.SINGLETON);
            binder.bind(DependentInstance.class).in(Scopes.SINGLETON);
        }});
        injector.getInstance(AnotherInstance.class);
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"postDependentInstance"));
        lifeCycleManager.stop();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"postDependentInstance", (Object)"preDependentInstance"));
    }

    @Test
    public void testIllegalMethods() {
        try {
            Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{binder -> binder.bind(IllegalInstance.class).in(Scopes.SINGLETON), new LifeCycleModule()});
            Assertions.fail();
        }
        catch (CreationException creationException) {
            // empty catch block
        }
    }

    @Test
    public void testDuplicateMethodNames() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{binder -> binder.bind(FooTestInstance.class).in(Scopes.SINGLETON), new LifeCycleModule()});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        lifeCycleManager.stop();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"foo"));
    }

    @Test
    public void testJITInjection() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(AnInstance.class).in(Scopes.SINGLETON);
            binder.bind(DependentInstance.class).in(Scopes.SINGLETON);
        }});
        injector.getInstance(AnInstance.class);
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        lifeCycleManager.stop();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"postDependentInstance", (Object)"preDependentInstance"));
    }

    @Test
    public void testPreDestroySuppressedExceptionHandling() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(DependentInstance.class).in(Scopes.SINGLETON);
            binder.bind(DestroyExceptionInstance.class).in(Scopes.SINGLETON);
        }});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"postDependentInstance"));
        try {
            lifeCycleManager.stopWithoutFailureLogging();
            Assertions.fail((String)"Expected exception to be thrown");
        }
        catch (LifeCycleStopException e) {
            ((ObjectArrayAssert)Assertions.assertThat((Object[])e.getSuppressed()).as("Expected two suppressed exceptions", new Object[0])).hasSize(2);
            Set suppressedMessages = Arrays.stream(e.getSuppressed()).map(Throwable::getMessage).collect(Collectors.toSet());
            Assertions.assertThat((Collection)ImmutableSet.copyOf(suppressedMessages)).isEqualTo((Object)ImmutableSet.of((Object)"preDestroyExceptionOne", (Object)"preDestroyExceptionTwo"));
        }
        Assertions.assertThat((Collection)ImmutableSet.copyOf(stateLog)).isEqualTo((Object)ImmutableSet.of((Object)"postDependentInstance", (Object)"preDestroyExceptionOne", (Object)"preDestroyExceptionTwo", (Object)"preDependentInstance"));
    }

    @Test
    public void testPreDestroyLoggingExceptionHandling() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(DependentInstance.class).in(Scopes.SINGLETON);
            binder.bind(DestroyExceptionInstance.class).in(Scopes.SINGLETON);
        }});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"postDependentInstance"));
        try {
            lifeCycleManager.stop();
            Assertions.fail((String)"Expected exception to be thrown");
        }
        catch (LifeCycleStopException e) {
            ((ObjectArrayAssert)Assertions.assertThat((Object[])e.getSuppressed()).as("Suppressed exceptions list should be empty", new Object[0])).hasSize(0);
        }
        Assertions.assertThat((Collection)ImmutableSet.copyOf(stateLog)).isEqualTo((Object)ImmutableSet.of((Object)"postDependentInstance", (Object)"preDestroyExceptionOne", (Object)"preDestroyExceptionTwo", (Object)"preDependentInstance"));
    }

    @Test
    public void testPostConstructExceptionCallsPreDestroy() {
        try {
            Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> binder.bind(PostConstructExceptionInstance.class).in(Scopes.SINGLETON)});
            Assertions.fail((String)"Expected injector creation to fail with an exception");
        }
        catch (CreationException e) {
            Assertions.assertThat((Collection)ImmutableSet.copyOf(stateLog)).isEqualTo((Object)ImmutableSet.of((Object)"postConstructFailure", (Object)"preDestroyFailureAfterPostConstructFailureOne", (Object)"preDestroyFailureAfterPostConstructFailureTwo"));
            ((ClassAssert)Assertions.assertThat(e.getCause().getClass()).as("Expected LifeCycleStartException to be thrown, found: " + String.valueOf(e.getCause().getClass()), new Object[0])).isEqualTo(LifeCycleStartException.class);
            ((ObjectArrayAssert)Assertions.assertThat((Object[])e.getCause().getSuppressed()).as("Expected two suppressed exceptions", new Object[0])).hasSize(2);
            Assertions.assertThat((Collection)ImmutableSet.copyOf((Collection)Arrays.stream(e.getCause().getSuppressed()).map(Throwable::getCause).map(Throwable::getMessage).collect(Collectors.toSet()))).isEqualTo((Object)ImmutableSet.of((Object)"preDestroyFailureAfterPostConstructFailureOne", (Object)"preDestroyFailureAfterPostConstructFailureTwo"));
        }
    }

    @Test
    public void testNoPreDestroy() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(PostConstructOnly.class).in(Scopes.SINGLETON);
            binder.bind(PreDestroyOnly.class).in(Scopes.SINGLETON);
        }});
        injector.getInstance(PostConstructOnly.class);
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"makeMe"));
        lifeCycleManager.stop();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"makeMe", (Object)"unmakeMe"));
    }

    @Test
    public void testModule() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(DependentBoundInstance.class).to(DependentInstanceImpl.class).in(Scopes.SINGLETON);
            binder.bind(DependentInstance.class).in(Scopes.SINGLETON);
            binder.bind(InstanceOne.class).in(Scopes.SINGLETON);
            binder.bind(InstanceTwo.class).in(Scopes.SINGLETON);
        }});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        lifeCycleManager.stop();
        HashSet<String> stateLogSet = new HashSet<String>(stateLog);
        Assertions.assertThat(stateLogSet).isEqualTo((Object)Sets.newHashSet((Object[])new String[]{"postDependentBoundInstance", "postDependentInstance", "postMakeOne", "postMakeTwo", "preDestroyTwo", "preDestroyOne", "preDependentInstance", "preDependentBoundInstance"}));
    }

    @Test
    public void testProvider() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> binder.bind(BarInstance.class).toProvider(BarProvider.class).in(Scopes.SINGLETON)});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"postBarProvider", (Object)"postBarInstance"));
        lifeCycleManager.stop();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"postBarProvider", (Object)"postBarInstance", (Object)"preBarInstance", (Object)"preBarProvider"));
    }

    @Test
    public void testProviderMethod() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), new Module(this){

            public void configure(Binder binder) {
            }

            @Provides
            @Singleton
            public BarInstance create() {
                return new BarInstance();
            }
        }});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"postBarInstance"));
        lifeCycleManager.stop();
        Assertions.assertThat(stateLog).isEqualTo((Object)ImmutableList.of((Object)"postBarInstance", (Object)"preBarInstance"));
    }

    @Test
    public void testProviderReturningNull() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), new Module(this){

            public void configure(Binder binder) {
            }

            @Provides
            public BarInstance createBar() {
                return null;
            }
        }});
        Assertions.assertThat((Object)((BarInstance)injector.getInstance(BarInstance.class))).isNull();
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        lifeCycleManager.stop();
        Assertions.assertThat((Object)((BarInstance)injector.getInstance(BarInstance.class))).isNull();
    }
}

