/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import info.debatty.java.stringsimilarity.JaroWinkler;
import info.debatty.java.stringsimilarity.interfaces.StringSimilarity;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

class FuzzyMatcher {
    private static final StringSimilarity SIMILARITY = new JaroWinkler();

    private FuzzyMatcher() {
    }

    public static List<String> findSimilar(String key, Set<String> candidates, int count) {
        if (candidates.contains(key)) {
            throw new IllegalArgumentException("Key '%s' is already present in the %s candidates".formatted(key, candidates));
        }
        return (List)candidates.stream().map(candidate -> new Match((String)candidate, SIMILARITY.similarity(candidate, key))).filter(match -> match.ratio() > 0.85).sorted(Comparator.comparingDouble(Match::ratio).reversed()).limit(count).map(Match::key).collect(ImmutableList.toImmutableList());
    }

    private record Match(String key, double ratio) {
        public Match {
            Objects.requireNonNull(key, "key is null");
            Verify.verify((ratio >= 0.0 && ratio <= 1.0 ? 1 : 0) != 0, (String)"ratio must be in the [0, 1.0] range", (Object[])new Object[0]);
        }
    }
}

